/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel;

import cn.gjing.tools.excel.Excel;
import cn.gjing.tools.excel.exception.ExcelInitException;
import cn.gjing.tools.excel.exception.ExcelTemplateException;
import cn.gjing.tools.excel.metadata.ExcelFieldProperty;
import cn.gjing.tools.excel.metadata.ExcelType;
import cn.gjing.tools.excel.read.ExcelReaderContext;
import cn.gjing.tools.excel.read.resolver.ExcelBindReader;
import cn.gjing.tools.excel.read.resolver.ExcelSimpleReader;
import cn.gjing.tools.excel.util.BeanUtils;
import cn.gjing.tools.excel.util.ParamUtils;
import cn.gjing.tools.excel.write.ExcelWriterContext;
import cn.gjing.tools.excel.write.resolver.ExcelBindWriter;
import cn.gjing.tools.excel.write.resolver.ExcelSimpleWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public final class ExcelFactory {
    private ExcelFactory() {
    }

    public static ExcelBindWriter createWriter(Class<?> excelClass, HttpServletResponse response, String ... ignores) {
        return ExcelFactory.createWriter(null, excelClass, response, true, ignores);
    }

    public static ExcelBindWriter createWriter(Class<?> excelClass, HttpServletResponse response, boolean initDefaultStyle, String ... ignores) {
        return ExcelFactory.createWriter(null, excelClass, response, initDefaultStyle, ignores);
    }

    public static ExcelBindWriter createWriter(String fileName, Class<?> excelClass, HttpServletResponse response, String ... ignores) {
        return ExcelFactory.createWriter(fileName, excelClass, response, true, ignores);
    }

    public static ExcelBindWriter createWriter(String fileName, Class<?> excelClass, HttpServletResponse response, boolean initDefaultStyle, String ... ignores) {
        ParamUtils.requireNonNull(excelClass, "Excel mapping class cannot be null");
        Excel excel = excelClass.getAnnotation(Excel.class);
        ParamUtils.requireNonNull(excel, "@Excel annotation was not found on the " + excelClass);
        ArrayList<ExcelFieldProperty> properties = new ArrayList<ExcelFieldProperty>();
        ExcelWriterContext context = new ExcelWriterContext();
        context.setExcelFields(BeanUtils.getExcelFields(excelClass, ignores, properties));
        context.setExcelClass(excelClass);
        context.setFieldProperties(properties);
        context.setExcelType(excel.type());
        context.setFileName(StringUtils.isEmpty((Object)fileName) ? ("".equals(excel.value()) ? LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) : excel.value()) : fileName);
        context.setHeaderHeight(excel.headerHeight());
        context.setHeaderSeries(((ExcelFieldProperty)properties.get(0)).getValue().length);
        context.setBodyHeight(excel.bodyHeight());
        context.setUniqueKey("".equals(excel.uniqueKey()) ? excelClass.getName() : excel.uniqueKey());
        return new ExcelBindWriter(context, excel, response, initDefaultStyle);
    }

    public static ExcelSimpleWriter createSimpleWriter(String fileName, HttpServletResponse response, boolean initDefaultStyle) {
        return ExcelFactory.createSimpleWriter(fileName, response, ExcelType.XLS, 500, initDefaultStyle);
    }

    public static ExcelSimpleWriter createSimpleWriter(String fileName, HttpServletResponse response, ExcelType excelType) {
        return ExcelFactory.createSimpleWriter(fileName, response, excelType, 500, true);
    }

    public static ExcelSimpleWriter createSimpleWriter(String fileName, HttpServletResponse response, ExcelType excelType, int windowSize) {
        return ExcelFactory.createSimpleWriter(fileName, response, excelType, windowSize, true);
    }

    public static ExcelSimpleWriter createSimpleWriter(String fileName, HttpServletResponse response, ExcelType excelType, int windowSize, boolean initDefaultStyle) {
        ExcelWriterContext context = new ExcelWriterContext();
        context.setFileName(StringUtils.isEmpty((Object)fileName) ? LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) : fileName);
        context.setExcelType(excelType);
        context.setExcelClass(Object.class);
        context.setBind(false);
        return new ExcelSimpleWriter(context, windowSize, response, initDefaultStyle);
    }

    public static <R> ExcelBindReader<R> createReader(MultipartFile file, Class<R> excelClass, String ... ignores) {
        try {
            ExcelType excelType = ParamUtils.getExcelType(file.getOriginalFilename());
            if (excelType == null) {
                throw new ExcelTemplateException("File type does not belong to Excel");
            }
            return ExcelFactory.createReader(file.getInputStream(), excelClass, excelType, ignores);
        }
        catch (IOException e) {
            throw new ExcelInitException("Create excel reader error," + e.getMessage());
        }
    }

    public static <R> ExcelBindReader<R> createReader(File file, Class<R> excelClass, String ... ignores) {
        try {
            ExcelType excelType = ParamUtils.getExcelType(file.getName());
            if (excelType == null) {
                throw new ExcelTemplateException("File type does not belong to Excel");
            }
            return ExcelFactory.createReader(new FileInputStream(file), excelClass, excelType, ignores);
        }
        catch (IOException e) {
            throw new ExcelInitException("Create excel reader error," + e.getMessage());
        }
    }

    public static <R> ExcelBindReader<R> createReader(InputStream inputStream, Class<R> excelClass, ExcelType excelType, String ... ignores) {
        ParamUtils.requireNonNull(excelClass, "Excel mapping class cannot be null");
        Excel excel = excelClass.getAnnotation(Excel.class);
        ParamUtils.requireNonNull(excel, "@Excel annotation was not found on the " + excelClass);
        ExcelReaderContext<R> readerContext = new ExcelReaderContext<R>(excelClass, BeanUtils.getExcelFieldsMap(excelClass), ignores);
        readerContext.setUniqueKey("".equals(excel.uniqueKey()) ? excelClass.getName() : excel.uniqueKey());
        return new ExcelBindReader<R>(readerContext, inputStream, excelType, excel.cacheRowSize(), excel.bufferSize());
    }

    public static <R> ExcelSimpleReader<R> createSimpleReader(File file, int cacheRow, int bufferSize, String ... ignores) {
        try {
            ExcelType excelType = ParamUtils.getExcelType(file.getName());
            if (excelType == null) {
                throw new ExcelTemplateException("File type does not belong to Excel");
            }
            return ExcelFactory.createSimpleReader(new FileInputStream(file), excelType, cacheRow, bufferSize, ignores);
        }
        catch (IOException e) {
            throw new ExcelInitException("Create excel reader error," + e.getMessage());
        }
    }

    public static <R> ExcelSimpleReader<R> createSimpleReader(File file, String ... ignores) {
        try {
            ExcelType excelType = ParamUtils.getExcelType(file.getName());
            if (excelType == null) {
                throw new ExcelTemplateException("File type does not belong to Excel");
            }
            return ExcelFactory.createSimpleReader(new FileInputStream(file), excelType, 100, 2048, ignores);
        }
        catch (IOException e) {
            throw new ExcelInitException("Create excel reader error," + e.getMessage());
        }
    }

    public static <R> ExcelSimpleReader<R> createSimpleReader(MultipartFile file, int cacheRow, int bufferSize, String ... ignores) {
        try {
            ExcelType excelType = ParamUtils.getExcelType(file.getOriginalFilename());
            if (excelType == null) {
                throw new ExcelTemplateException("File type does not belong to Excel");
            }
            return ExcelFactory.createSimpleReader(file.getInputStream(), excelType, cacheRow, bufferSize, ignores);
        }
        catch (IOException e) {
            throw new ExcelInitException("Create excel reader error," + e.getMessage());
        }
    }

    public static <R> ExcelSimpleReader<R> createSimpleReader(MultipartFile file, String ... ignores) {
        try {
            ExcelType excelType = ParamUtils.getExcelType(file.getOriginalFilename());
            if (excelType == null) {
                throw new ExcelTemplateException("File type does not belong to Excel");
            }
            return ExcelFactory.createSimpleReader(file.getInputStream(), excelType, 100, 2048, ignores);
        }
        catch (IOException e) {
            throw new ExcelInitException("Create excel reader error," + e.getMessage());
        }
    }

    public static <R> ExcelSimpleReader<R> createSimpleReader(InputStream inputStream, ExcelType excelType, int cacheRow, int bufferSize, String ... ignores) {
        ExcelReaderContext readerContext = new ExcelReaderContext(null, null, ignores);
        return new ExcelSimpleReader(readerContext, inputStream, excelType, cacheRow, bufferSize);
    }
}

