/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.write.resolver;

import cn.gjing.tools.excel.metadata.ExcelWriterResolver;
import cn.gjing.tools.excel.write.BigTitle;
import cn.gjing.tools.excel.write.ExcelWriterContext;
import cn.gjing.tools.excel.write.callback.ExcelAutoMergeCallback;
import cn.gjing.tools.excel.write.listener.ExcelWriteListener;
import cn.gjing.tools.excel.write.resolver.ExcelBaseWriter;
import cn.gjing.tools.excel.write.style.DefaultExcelStyleListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletResponse;

public final class ExcelSimpleWriter
extends ExcelBaseWriter {
    private boolean mergeEmpty = true;

    public ExcelSimpleWriter(ExcelWriterContext context, int windowSize, HttpServletResponse response, boolean initDefaultStyle) {
        super(context, windowSize, response, initDefaultStyle);
    }

    @Override
    protected void initStyle() {
        this.context.addListener(new DefaultExcelStyleListener());
    }

    public ExcelSimpleWriter head(List<String[]> headNames) {
        this.context.setHeadNames(headNames);
        return this;
    }

    public ExcelSimpleWriter writeTitle(BigTitle bigTitle) {
        this.getClass();
        return this.writeTitle(bigTitle, "Sheet1");
    }

    public ExcelSimpleWriter writeTitle(BigTitle bigTitle, String sheetName) {
        if (bigTitle != null) {
            this.createSheet(sheetName);
            if (bigTitle.getLastCols() < 1) {
                bigTitle.setLastCols(this.context.getHeadNames().size() - 1);
            }
            this.writerResolver.writeTitle(bigTitle);
        }
        return this;
    }

    public ExcelSimpleWriter write(List<List<Object>> data) {
        this.getClass();
        return this.write(data, "Sheet1", true, null);
    }

    public ExcelSimpleWriter write(List<List<Object>> data, String sheetName) {
        return this.write(data, sheetName, true, null);
    }

    public ExcelSimpleWriter write(List<List<Object>> data, boolean needHead) {
        this.getClass();
        return this.write(data, "Sheet1", needHead, null);
    }

    public ExcelSimpleWriter write(List<List<Object>> data, String sheetName, boolean needHead) {
        return this.write(data, sheetName, needHead, null);
    }

    public ExcelSimpleWriter write(List<List<Object>> data, Map<String, ExcelAutoMergeCallback<?>> callback) {
        this.getClass();
        return this.write(data, "Sheet1", true, callback);
    }

    public ExcelSimpleWriter write(List<List<Object>> data, String sheetName, Map<String, ExcelAutoMergeCallback<?>> callback) {
        return this.write(data, sheetName, true, callback);
    }

    public ExcelSimpleWriter write(List<List<Object>> data, boolean needHead, Map<String, ExcelAutoMergeCallback<?>> callback) {
        this.getClass();
        return this.write(data, "Sheet1", needHead, callback);
    }

    public ExcelSimpleWriter write(List<List<Object>> data, String sheetName, boolean needHead, Map<String, ExcelAutoMergeCallback<?>> callback) {
        this.createSheet(sheetName);
        this.writerResolver.simpleWriteHead(needHead).simpleWrite(data, this.mergeEmpty, callback == null ? new HashMap(2) : callback);
        return this;
    }

    public ExcelSimpleWriter mergeEmpty(boolean mergeEmpty) {
        this.mergeEmpty = mergeEmpty;
        return this;
    }

    public ExcelSimpleWriter multiHead(boolean multi) {
        this.context.setMultiHead(multi);
        return this;
    }

    public ExcelSimpleWriter identifier(boolean identifier) {
        this.context.setIdentifier(identifier);
        return this;
    }

    public ExcelSimpleWriter addListener(ExcelWriteListener listener) {
        if (listener != null) {
            this.context.addListener(listener);
        }
        return this;
    }

    public ExcelSimpleWriter addListener(List<? extends ExcelWriteListener> listeners) {
        if (listeners != null) {
            listeners.forEach(this.context::addListener);
        }
        return this;
    }

    public ExcelSimpleWriter resetResolver(Supplier<? extends ExcelWriterResolver> excelWriteResolver) {
        this.writerResolver = excelWriteResolver.get();
        return this;
    }
}

