/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.write.resolver;

import cn.gjing.tools.excel.Excel;
import cn.gjing.tools.excel.metadata.ExcelWriterResolver;
import cn.gjing.tools.excel.util.BeanUtils;
import cn.gjing.tools.excel.util.ParamUtils;
import cn.gjing.tools.excel.write.BigTitle;
import cn.gjing.tools.excel.write.ExcelWriterContext;
import cn.gjing.tools.excel.write.listener.ExcelWriteListener;
import cn.gjing.tools.excel.write.resolver.ExcelBaseWriter;
import cn.gjing.tools.excel.write.style.DefaultExcelStyleListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletResponse;

public final class ExcelBindWriter
extends ExcelBaseWriter {
    public ExcelBindWriter(ExcelWriterContext context, Excel excel, HttpServletResponse response, boolean initDefaultStyle) {
        super(context, excel.windowSize(), response, initDefaultStyle);
    }

    @Override
    protected void initStyle() {
        this.context.addListener(new DefaultExcelStyleListener());
    }

    public ExcelBindWriter write(List<?> data) {
        this.getClass();
        return this.write(data, "Sheet1", true, null);
    }

    public ExcelBindWriter write(List<?> data, String sheetName) {
        return this.write(data, sheetName, true, null);
    }

    public ExcelBindWriter write(List<?> data, boolean needHead) {
        this.getClass();
        return this.write(data, "Sheet1", needHead, null);
    }

    public ExcelBindWriter write(List<?> data, String sheetName, boolean needHead) {
        return this.write(data, sheetName, needHead, null);
    }

    public ExcelBindWriter write(List<?> data, Map<String, String[]> boxValues) {
        this.getClass();
        return this.write(data, "Sheet1", true, boxValues);
    }

    public ExcelBindWriter write(List<?> data, String sheetName, Map<String, String[]> boxValues) {
        return this.write(data, sheetName, true, boxValues);
    }

    public ExcelBindWriter write(List<?> data, boolean needHead, Map<String, String[]> boxValues) {
        this.getClass();
        return this.write(data, "Sheet1", needHead, boxValues);
    }

    public ExcelBindWriter write(List<?> data, String sheetName, boolean needHead, Map<String, String[]> boxValues) {
        this.createSheet(sheetName);
        this.writerResolver.writeHead(needHead, boxValues).write(data);
        return this;
    }

    public ExcelBindWriter writeTitle(BigTitle bigTitle) {
        this.getClass();
        return this.writeTitle(bigTitle, "Sheet1");
    }

    public ExcelBindWriter writeTitle(BigTitle bigTitle, String sheetName) {
        if (bigTitle != null) {
            this.createSheet(sheetName);
            if (bigTitle.getLastCols() < 1) {
                bigTitle.setLastCols(this.context.getExcelFields().size() - 1);
            }
            this.writerResolver.writeTitle(bigTitle);
        }
        return this;
    }

    public ExcelBindWriter resetExcelClass(Class<?> excelClass, boolean resetListener, String ... ignores) {
        Excel excel = excelClass.getAnnotation(Excel.class);
        ParamUtils.requireNonNull(excel, "Failed to reset Excel class, the @Excel annotation was not found on the " + excelClass);
        ArrayList<String[]> headNames = new ArrayList<String[]>();
        this.context.setExcelFields(BeanUtils.getExcelFields(excelClass, ignores, headNames));
        this.context.setHeadNames(headNames);
        this.context.setExcelClass(excelClass);
        if (resetListener) {
            this.context.getWriteListenerCache().clear();
        }
        return this;
    }

    @Deprecated
    public ExcelBindWriter enableValid() {
        this.context.setNeedValid(true);
        return this;
    }

    @Deprecated
    public ExcelBindWriter closeValid() {
        this.context.setNeedValid(false);
        return this;
    }

    public ExcelBindWriter valid(boolean valid) {
        this.context.setNeedValid(valid);
        return this;
    }

    @Deprecated
    public ExcelBindWriter enableMultiHead() {
        this.context.setMultiHead(true);
        return this;
    }

    @Deprecated
    public ExcelBindWriter closeMultiHead() {
        this.context.setMultiHead(false);
        return this;
    }

    public ExcelBindWriter multiHead(boolean multi) {
        this.context.setMultiHead(multi);
        return this;
    }

    public ExcelBindWriter identifier(boolean identifier) {
        this.context.setIdentifier(identifier);
        return this;
    }

    public ExcelBindWriter addListener(ExcelWriteListener listener) {
        if (listener != null) {
            this.context.addListener(listener);
        }
        return this;
    }

    public ExcelBindWriter addListener(List<? extends ExcelWriteListener> listeners) {
        if (listeners != null) {
            listeners.forEach(this.context::addListener);
        }
        return this;
    }

    public ExcelBindWriter resetResolver(Supplier<? extends ExcelWriterResolver> excelWriteResolver) {
        this.writerResolver = excelWriteResolver.get();
        return this;
    }
}

