/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.write.resolver;

import cn.gjing.tools.excel.exception.ExcelInitException;
import cn.gjing.tools.excel.metadata.ExcelWriterResolver;
import cn.gjing.tools.excel.util.ListenerChain;
import cn.gjing.tools.excel.write.ExcelWriterContext;
import cn.gjing.tools.excel.write.resolver.ExcelWriteXlsResolver;
import cn.gjing.tools.excel.write.resolver.ExcelWriteXlsxResolver;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public abstract class ExcelBaseWriter {
    protected ExcelWriterContext context;
    protected HttpServletResponse response;
    protected ExcelWriterResolver writerResolver;
    protected final String defaultSheetName = "Sheet1";

    protected ExcelBaseWriter(ExcelWriterContext context, int windowSize, HttpServletResponse response, boolean initDefaultStyle) {
        this.response = response;
        this.context = context;
        this.chooseResolver(context, windowSize);
        if (initDefaultStyle) {
            this.initStyle();
        }
    }

    protected abstract void initStyle();

    protected void chooseResolver(ExcelWriterContext context, int windowSize) {
        switch (this.context.getExcelType()) {
            case XLS: {
                context.setWorkbook((Workbook)new HSSFWorkbook());
                this.writerResolver = new ExcelWriteXlsResolver();
                this.writerResolver.init(context);
                break;
            }
            case XLSX: {
                context.setWorkbook((Workbook)new SXSSFWorkbook(windowSize));
                this.writerResolver = new ExcelWriteXlsxResolver();
                this.writerResolver.init(context);
                break;
            }
            default: {
                throw new ExcelInitException("No corresponding resolver was found");
            }
        }
    }

    public void flush() {
        ListenerChain.doWorkbookFlushBefore(this.context);
        if (this.context.isIdentifier()) {
            this.context.getWorkbook().createSheet("identificationSheet").createRow(0).createCell(0).setCellValue(this.context.getExcelClass().getSimpleName());
            this.context.getWorkbook().setSheetHidden(this.context.getWorkbook().getSheetIndex("identificationSheet"), true);
        }
        this.writerResolver.flush(this.response, this.context, this.context.getExcelType());
        if (this.context.getWorkbook() instanceof SXSSFWorkbook) {
            ((SXSSFWorkbook)this.context.getWorkbook()).dispose();
        }
    }

    public void createSheet(String sheetName) {
        Sheet sheet = this.context.getWorkbook().getSheet(sheetName);
        if (sheet == null) {
            sheet = this.context.getWorkbook().createSheet(sheetName);
            this.context.setSheet(sheet);
            ListenerChain.doCompleteSheet(this.context);
        }
    }
}

