/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.util;

import cn.gjing.tools.excel.exception.ExcelResolverException;
import java.util.Iterator;
import java.util.Map;

public final class ParamUtils {
    public static boolean contains(String[] arr, String val) {
        if (arr == null || arr.length == 0) {
            return false;
        }
        for (String o : arr) {
            if (!o.equals(val)) continue;
            return true;
        }
        return false;
    }

    public static boolean equals(Object param1, Object param2, boolean allowEmpty) {
        if (allowEmpty) {
            if (param1 == param2) {
                return true;
            }
            return param1 != null && param1.equals(param2);
        }
        if (param1 == null || "".equals(param1)) {
            return false;
        }
        return param1 == param2 || param1.equals(param2);
    }

    public static <T> void requireNonNull(T obj, String message) {
        if (obj == null) {
            throw new ExcelResolverException(message);
        }
    }

    public static String createFormulaX(int startColIndex, int rowIndex, int endColIndex) {
        char endSuffix;
        char start = (char)(65 + startColIndex);
        if (endColIndex <= 25) {
            if (endColIndex == 0) {
                return "$" + start + "$" + rowIndex;
            }
            char end = (char)(start + endColIndex - 1);
            return "$" + start + "$" + rowIndex + ":$" + end + "$" + rowIndex;
        }
        char endPrefix = 'A';
        if ((endColIndex - 25) % 26 == 0) {
            endSuffix = 'Z';
            endPrefix = (char)(endPrefix + (endColIndex - 25) / 26 - 1);
        } else {
            endSuffix = (char)(65 + (endColIndex - 25) % 26 - 1);
            endPrefix = (char)(endPrefix + (endColIndex - 25) / 26);
        }
        return "$" + start + "$" + rowIndex + ":$" + endPrefix + endSuffix + "$" + rowIndex;
    }

    public static String createFormulaY(int colIndex, int startRow, int endRow) {
        if (colIndex < 26) {
            return "$" + (char)(65 + colIndex) + "$" + startRow + ":$" + (char)(65 + colIndex) + "$" + endRow;
        }
        String all = ParamUtils.numberToEn(colIndex);
        return "$" + all + "$" + startRow + ":$" + all + "$" + endRow;
    }

    public static String numberToEn(int number) {
        char suffix;
        char prefix = 'A';
        if (number < 26) {
            return "" + (char)(65 + number);
        }
        if ((number - 25) % 26 == 0) {
            suffix = (char)(prefix + 25);
            prefix = (char)(prefix + (number - 25) / 26 - 1);
        } else {
            suffix = (char)(65 + (number - 25) % 26 - 1);
            prefix = (char)(prefix + (number - 25) / 26);
        }
        return "" + prefix + suffix;
    }

    public static void deleteMapKey(Map<?, ?> map, String key) {
        Iterator<Map.Entry<?, ?>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<?, ?> next = iterator.next();
            if (!next.getKey().equals(key)) continue;
            iterator.remove();
            break;
        }
    }

    public static boolean isExcel(String fileName) {
        if (fileName == null) {
            return false;
        }
        int pos = fileName.lastIndexOf(".") + 1;
        String extension = fileName.substring(pos);
        return "xls".equals(extension) || "xlsx".equals(extension);
    }
}

