/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.read.resolver;

import cn.gjing.tools.excel.ExcelField;
import cn.gjing.tools.excel.convert.DataConvert;
import cn.gjing.tools.excel.convert.DefaultDataConvert;
import cn.gjing.tools.excel.convert.ExcelDataConvert;
import cn.gjing.tools.excel.exception.ExcelAssertException;
import cn.gjing.tools.excel.exception.ExcelInitException;
import cn.gjing.tools.excel.exception.ExcelResolverException;
import cn.gjing.tools.excel.exception.ExcelTemplateException;
import cn.gjing.tools.excel.metadata.ExcelReaderResolver;
import cn.gjing.tools.excel.read.ExcelReaderContext;
import cn.gjing.tools.excel.read.listener.ExcelEmptyReadListener;
import cn.gjing.tools.excel.read.listener.ExcelReadListener;
import cn.gjing.tools.excel.read.listener.ExcelRowReadListener;
import cn.gjing.tools.excel.read.valid.ExcelAssert;
import cn.gjing.tools.excel.util.BeanUtils;
import cn.gjing.tools.excel.util.ListenerChain;
import cn.gjing.tools.excel.util.ParamUtils;
import com.google.gson.Gson;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

class ReadExecutor<R>
implements ExcelReaderResolver<R> {
    private ExcelReaderContext<R> context;
    private Map<Class<? extends DataConvert<?>>, DataConvert<?>> dataConvertMap;
    private Boolean save;

    ReadExecutor() {
    }

    @Override
    public void init(ExcelReaderContext<R> readerContext) {
        this.context = readerContext;
        this.dataConvertMap = new HashMap(16);
        this.dataConvertMap.put(DefaultDataConvert.class, new DefaultDataConvert());
    }

    @Override
    public void read(int headerIndex, String sheetName) {
        Sheet sheet;
        if (this.context.isCheckTemplate()) {
            if (this.context.getWorkbook().getSheetIndex("identificationSheet") == -1) {
                throw new ExcelTemplateException();
            }
            Iterator iterator = this.context.getWorkbook().getSheet("identificationSheet").iterator();
            if (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                if (!ParamUtils.equals(this.context.getExcelClass().getSimpleName(), row.getCell(0).getStringCellValue(), false)) {
                    throw new ExcelTemplateException();
                }
            }
        }
        if ((sheet = this.context.getWorkbook().getSheet(sheetName)) == null) {
            throw new ExcelResolverException("The" + sheetName + " is not found in the workbook");
        }
        this.context.setSheet(sheet);
        this.reader(headerIndex, this.context.getResultReadListener() == null ? null : new ArrayList());
    }

    private void reader(int headerIndex, List<R> dataList) {
        this.save = true;
        boolean stop = false;
        SpelExpressionParser parser = new SpelExpressionParser();
        StandardEvaluationContext context = new StandardEvaluationContext();
        List<ExcelReadListener> rowReadListeners = this.context.getReadListenersCache().get(ExcelRowReadListener.class);
        Gson gson = new Gson();
        ListenerChain.doReadBefore(rowReadListeners, this.context);
        for (Row row : this.context.getSheet()) {
            if (stop) break;
            if (row.getRowNum() > headerIndex) {
                R r;
                try {
                    r = this.context.getExcelClass().newInstance();
                    context.setVariable(this.context.getExcelClass().getSimpleName(), r);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new ExcelInitException("Excel entity init failure, " + e.getMessage());
                }
                int fieldSize = this.context.getExcelFields().size();
                for (int c = 0; c < fieldSize && this.save.booleanValue(); ++c) {
                    Field field = this.context.getExcelFields().get(c);
                    ExcelField excelField = field.getAnnotation(ExcelField.class);
                    Cell valueCell = row.getCell(c);
                    try {
                        Object value;
                        if (valueCell != null) {
                            value = this.getValue(r, valueCell, field, excelField, gson);
                            context.setVariable(field.getName(), value);
                            this.assertValue((ExpressionParser)parser, (EvaluationContext)context, row, c, field, excelField);
                            value = ListenerChain.doReadCell(rowReadListeners, value, field, row.getRowNum(), c, false, true);
                            value = this.convert(field, value, (ExpressionParser)parser, (EvaluationContext)context, this.createDataConvert(field, excelField));
                            if (this.save.booleanValue() && value != null) {
                                this.setValue(r, field, value);
                            }
                        } else {
                            this.allowEmpty(r, field, excelField, row.getRowNum(), c);
                            context.setVariable(field.getName(), null);
                            this.assertValue((ExpressionParser)parser, (EvaluationContext)context, row, c, field, excelField);
                            value = ListenerChain.doReadCell(rowReadListeners, null, field, row.getRowNum(), c, false, true);
                            value = this.convert(field, value, (ExpressionParser)parser, (EvaluationContext)context, this.createDataConvert(field, excelField));
                            this.setValue(r, field, value);
                        }
                        context.setVariable(field.getName(), value);
                        continue;
                    }
                    catch (Exception e) {
                        if (e instanceof ExcelAssertException) {
                            throw (ExcelAssertException)e;
                        }
                        throw new ExcelResolverException(e.getMessage());
                    }
                }
                if (!this.save.booleanValue()) continue;
                try {
                    if (dataList != null) {
                        dataList.add(r);
                    }
                    ListenerChain.doReadRow(rowReadListeners, r, null, row.getRowNum(), false, true);
                    continue;
                }
                catch (Exception e) {
                    throw new ExcelResolverException(e.getMessage());
                }
            }
            if (!this.context.isMetaInfo()) continue;
            boolean isHead = row.getRowNum() == headerIndex;
            ArrayList<Object> otherValues = new ArrayList<Object>();
            for (Cell cell : row) {
                otherValues.add(ListenerChain.doReadCell(rowReadListeners, cell.getStringCellValue(), null, row.getRowNum(), cell.getColumnIndex(), isHead, false));
            }
            stop = ListenerChain.doReadRow(rowReadListeners, null, otherValues, row.getRowNum(), isHead, false);
        }
        ListenerChain.doReadFinish(rowReadListeners, this.context);
        ListenerChain.doResultNotify(this.context.getResultReadListener(), dataList);
    }

    private Object getValue(R r, Cell cell, Field field, ExcelField excelField, Gson gson) {
        switch (cell.getCellType()) {
            case _NONE: 
            case BLANK: 
            case ERROR: {
                this.allowEmpty(r, field, excelField, cell.getRowIndex(), cell.getColumnIndex());
                break;
            }
            case BOOLEAN: {
                return cell.getBooleanCellValue();
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return cell.getDateCellValue();
                }
                return gson.fromJson(gson.toJson((Object)cell.getNumericCellValue()), field.getType());
            }
            case FORMULA: {
                return gson.fromJson(gson.toJson((Object)cell.getStringCellValue()), field.getType());
            }
            default: {
                return cell.getStringCellValue();
            }
        }
        return null;
    }

    private Object convert(Field field, Object value, ExpressionParser parser, EvaluationContext context, DataConvert<?> dataConvert) {
        ExcelDataConvert excelDataConvert = field.getAnnotation(ExcelDataConvert.class);
        if (excelDataConvert != null && !"".equals(excelDataConvert.expr2())) {
            return parser.parseExpression(excelDataConvert.expr2()).getValue(context);
        }
        return dataConvert.toEntityAttribute(value, field);
    }

    private DataConvert<?> createDataConvert(Field field, ExcelField excelField) {
        DataConvert<?> dataConvert = this.dataConvertMap.get(excelField.convert());
        if (dataConvert == null) {
            try {
                dataConvert = excelField.convert().newInstance();
                this.dataConvertMap.put(excelField.convert(), dataConvert);
            }
            catch (Exception e) {
                throw new ExcelInitException("Init specified excel header data converter failure " + field.getName() + ", " + e.getMessage());
            }
        }
        return dataConvert;
    }

    private void setValue(R o, Field field, Object value) {
        try {
            BeanUtils.setFieldValue(o, field, value);
        }
        catch (RuntimeException e) {
            if (field.getType() == LocalDate.class) {
                BeanUtils.setFieldValue(o, field, LocalDateTime.ofInstant(((Date)value).toInstant(), ZoneId.systemDefault()).toLocalDate());
                return;
            }
            if (field.getType() == LocalDateTime.class) {
                BeanUtils.setFieldValue(o, field, LocalDateTime.ofInstant(((Date)value).toInstant(), ZoneId.systemDefault()));
                return;
            }
            throw new IllegalArgumentException("Unsupported data type, you can use a data converter to convert " + value.getClass().getTypeName() + " to " + field.getType().getTypeName());
        }
    }

    private void allowEmpty(R r, Field field, ExcelField excelField, int rowIndex, int colIndex) {
        if (excelField.required()) {
            this.save = ListenerChain.doReadEmpty(this.context.getReadListenersCache().get(ExcelEmptyReadListener.class), r, field, excelField, rowIndex, colIndex);
        }
    }

    private void assertValue(ExpressionParser parser, EvaluationContext context, Row row, int c, Field field, ExcelField excelField) {
        Boolean test;
        ExcelAssert excelAssert = field.getAnnotation(ExcelAssert.class);
        if (excelAssert != null && (test = (Boolean)parser.parseExpression(excelAssert.expr()).getValue(context, Boolean.class)) != null && !test.booleanValue()) {
            throw new ExcelAssertException(excelAssert.message(), excelField, field, row.getRowNum(), c);
        }
    }
}

