/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.driven;

import cn.gjing.tools.excel.ExcelFactory;
import cn.gjing.tools.excel.driven.ExcelRead;
import cn.gjing.tools.excel.driven.ExcelReadWrapper;
import cn.gjing.tools.excel.exception.ExcelResolverException;
import cn.gjing.tools.excel.read.resolver.ExcelReader;
import org.springframework.core.MethodParameter;
import org.springframework.lang.NonNull;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

class ExcelDrivenReadHandler
implements HandlerMethodReturnValueHandler {
    ExcelDrivenReadHandler() {
    }

    public boolean supportsReturnType(MethodParameter methodParameter) {
        return methodParameter.hasMethodAnnotation(ExcelRead.class);
    }

    public void handleReturnValue(Object o, @NonNull MethodParameter methodParameter, @NonNull ModelAndViewContainer modelAndViewContainer, @NonNull NativeWebRequest nativeWebRequest) throws Exception {
        if (o instanceof ExcelReadWrapper) {
            modelAndViewContainer.setRequestHandled(true);
            ExcelRead readAnno = (ExcelRead)methodParameter.getMethodAnnotation(ExcelRead.class);
            assert (readAnno != null);
            ExcelReadWrapper wrapper = (ExcelReadWrapper)o;
            if (wrapper.getInputStream() == null) {
                throw new ExcelResolverException("The data cannot be empty");
            }
            ExcelReader reader = ExcelFactory.createReader(wrapper.getInputStream(), wrapper.getMapping(), wrapper.getIgnores() == null ? readAnno.ignores() : wrapper.getIgnores());
            reader.addListener(wrapper.getReadListeners()).subscribe(wrapper.getResultReadListener()).metaInfo(readAnno.metaInfo()).check(readAnno.check()).read(readAnno.headerIndex(), readAnno.value()).finish();
            return;
        }
        throw new ExcelResolverException("Method return value type must be ExcelReadWrapper: " + methodParameter.getExecutable().getName());
    }
}

