/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel;

import cn.gjing.tools.excel.Excel;
import cn.gjing.tools.excel.exception.ExcelInitException;
import cn.gjing.tools.excel.metadata.ExcelType;
import cn.gjing.tools.excel.read.ExcelReaderContext;
import cn.gjing.tools.excel.read.resolver.ExcelReader;
import cn.gjing.tools.excel.util.BeanUtils;
import cn.gjing.tools.excel.util.ParamUtils;
import cn.gjing.tools.excel.write.ExcelWriterContext;
import cn.gjing.tools.excel.write.resolver.ExcelBindWriter;
import cn.gjing.tools.excel.write.resolver.ExcelSimpleWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public final class ExcelFactory {
    private ExcelFactory() {
    }

    public static ExcelBindWriter createWriter(Class<?> excelClass, HttpServletResponse response, String ... ignores) {
        return ExcelFactory.createWriter(null, excelClass, response, true, ignores);
    }

    public static ExcelBindWriter createWriter(Class<?> excelClass, HttpServletResponse response, boolean initDefaultStyle, String ... ignores) {
        return ExcelFactory.createWriter(null, excelClass, response, initDefaultStyle, ignores);
    }

    public static ExcelBindWriter createWriter(String fileName, Class<?> excelClass, HttpServletResponse response, String ... ignores) {
        return ExcelFactory.createWriter(fileName, excelClass, response, true, ignores);
    }

    public static ExcelBindWriter createWriter(String fileName, Class<?> excelClass, HttpServletResponse response, boolean initDefaultStyle, String ... ignores) {
        Excel excel = excelClass.getAnnotation(Excel.class);
        ParamUtils.requireNonNull(excel, "@Excel annotation was not found on the " + excelClass);
        ArrayList<String[]> headerArr = new ArrayList<String[]>();
        ExcelWriterContext context = ExcelWriterContext.builder().excelFields(BeanUtils.getExcelFields(excelClass, ignores, headerArr)).headNames(headerArr).excelType(excel.type()).fileName(StringUtils.isEmpty((Object)fileName) ? ("".equals(excel.value()) ? LocalDateTime.now().toString() : excel.value()) : fileName).excelClass(excelClass).build();
        return new ExcelBindWriter(context, excel, response, initDefaultStyle);
    }

    public static ExcelSimpleWriter createSimpleWriter(String fileName, HttpServletResponse response, boolean initDefaultStyle) {
        return ExcelFactory.createSimpleWriter(fileName, response, ExcelType.XLS, 500, initDefaultStyle);
    }

    public static ExcelSimpleWriter createSimpleWriter(String fileName, HttpServletResponse response, ExcelType excelType) {
        return ExcelFactory.createSimpleWriter(fileName, response, excelType, 500, true);
    }

    public static ExcelSimpleWriter createSimpleWriter(String fileName, HttpServletResponse response, ExcelType excelType, int windowSize) {
        return ExcelFactory.createSimpleWriter(fileName, response, excelType, windowSize, true);
    }

    public static ExcelSimpleWriter createSimpleWriter(String fileName, HttpServletResponse response, ExcelType excelType, int windowSize, boolean initDefaultStyle) {
        ExcelWriterContext context = ExcelWriterContext.builder().fileName(fileName).excelType(excelType).excelClass(Void.class).build();
        return new ExcelSimpleWriter(context, windowSize, response, initDefaultStyle);
    }

    public static <R> ExcelReader<R> createReader(MultipartFile file, Class<R> excelClass, String ... ignores) {
        if (file == null) {
            throw new ExcelInitException("File cannot be null");
        }
        if (!ParamUtils.isExcel(file.getOriginalFilename())) {
            throw new ExcelInitException("File type error, file suffix name need to be xls or xlsx");
        }
        try {
            return ExcelFactory.createReader(file.getInputStream(), excelClass, ignores);
        }
        catch (IOException e) {
            throw new ExcelInitException("Create excel reader error," + e.getMessage());
        }
    }

    public static <R> ExcelReader<R> createReader(File file, Class<R> excelClass, String ... ignores) {
        if (file == null) {
            throw new ExcelInitException("File cannot be null");
        }
        if (!ParamUtils.isExcel(file.getName())) {
            throw new ExcelInitException("File type error, file suffix name need to be xls or xlsx");
        }
        try {
            return ExcelFactory.createReader(new FileInputStream(file), excelClass, ignores);
        }
        catch (IOException e) {
            throw new ExcelInitException("Create excel reader error," + e.getMessage());
        }
    }

    public static <R> ExcelReader<R> createReader(InputStream inputStream, Class<R> excelClass, String ... ignores) {
        Excel excel = excelClass.getAnnotation(Excel.class);
        ParamUtils.requireNonNull(excel, "@Excel annotation was not found on the " + excelClass);
        List<Field> excelFieldList = BeanUtils.getExcelFields(excelClass, ignores, null);
        ExcelReaderContext<R> readerContext = new ExcelReaderContext<R>(inputStream, excelClass, excelFieldList);
        return new ExcelReader<R>(readerContext, excel);
    }
}

