/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.write.resolver;

import cn.gjing.tools.excel.Excel;
import cn.gjing.tools.excel.exception.ExcelInitException;
import cn.gjing.tools.excel.metadata.ExcelWriterResolver;
import cn.gjing.tools.excel.util.BeanUtils;
import cn.gjing.tools.excel.util.ListenerChain;
import cn.gjing.tools.excel.util.ParamUtils;
import cn.gjing.tools.excel.write.BigTitle;
import cn.gjing.tools.excel.write.ExcelWriterContext;
import cn.gjing.tools.excel.write.listener.ExcelWriteListener;
import cn.gjing.tools.excel.write.resolver.ExcelWriteXlsResolver;
import cn.gjing.tools.excel.write.resolver.ExcelWriteXlsxResolver;
import cn.gjing.tools.excel.write.style.DefaultExcelStyleWriteListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public final class ExcelWriter {
    private ExcelWriterContext context;
    private HttpServletResponse response;
    private final String defaultSheetName = "Sheet1";
    private ExcelWriterResolver writerResolver;

    private ExcelWriter() {
    }

    public ExcelWriter(ExcelWriterContext context, Excel excel, HttpServletResponse response, boolean initDefaultStyle) {
        this.response = response;
        this.context = context;
        this.chooseResolver(context, excel);
        if (initDefaultStyle) {
            this.initStyle();
        }
    }

    private void chooseResolver(ExcelWriterContext context, Excel excel) {
        switch (excel.type()) {
            case XLS: {
                context.setWorkbook((Workbook)new HSSFWorkbook());
                this.writerResolver = new ExcelWriteXlsResolver();
                this.writerResolver.init(context);
                break;
            }
            case XLSX: {
                context.setWorkbook((Workbook)new SXSSFWorkbook(excel.windowSize()));
                this.writerResolver = new ExcelWriteXlsxResolver();
                this.writerResolver.init(context);
                break;
            }
            default: {
                throw new ExcelInitException("No corresponding resolver was found");
            }
        }
    }

    private void initStyle() {
        DefaultExcelStyleWriteListener defaultExcelStyle = new DefaultExcelStyleWriteListener();
        this.context.addListener(defaultExcelStyle);
    }

    public ExcelWriter write(List<?> data) {
        return this.write(data, this.defaultSheetName, true, null);
    }

    public ExcelWriter write(List<?> data, String sheetName) {
        return this.write(data, sheetName, true, null);
    }

    public ExcelWriter write(List<?> data, boolean needHead) {
        return this.write(data, this.defaultSheetName, needHead, null);
    }

    public ExcelWriter write(List<?> data, String sheetName, boolean needHead) {
        return this.write(data, sheetName, needHead, null);
    }

    public ExcelWriter write(List<?> data, Map<String, String[]> boxValues) {
        return this.write(data, this.defaultSheetName, true, boxValues);
    }

    public ExcelWriter write(List<?> data, String sheetName, Map<String, String[]> boxValues) {
        return this.write(data, sheetName, true, boxValues);
    }

    public ExcelWriter write(List<?> data, boolean needHead, Map<String, String[]> boxValues) {
        return this.write(data, this.defaultSheetName, needHead, boxValues);
    }

    public ExcelWriter write(List<?> data, String sheetName, boolean needHead, Map<String, String[]> boxValues) {
        this.createSheet(sheetName);
        this.writerResolver.writeHead(needHead, boxValues).write(data);
        return this;
    }

    public ExcelWriter writeTitle(BigTitle bigTitle) {
        return this.writeTitle(bigTitle, this.defaultSheetName);
    }

    public ExcelWriter writeTitle(BigTitle bigTitle, String sheetName) {
        if (bigTitle != null) {
            this.createSheet(sheetName);
            if (bigTitle.getLastCols() < 1) {
                bigTitle.setLastCols(this.context.getExcelFields().size() - 1);
            }
            this.writerResolver.writeTitle(bigTitle);
        }
        return this;
    }

    @Deprecated
    public ExcelWriter enableValid() {
        this.context.setNeedValid(true);
        return this;
    }

    @Deprecated
    public ExcelWriter closeValid() {
        this.context.setNeedValid(false);
        return this;
    }

    public ExcelWriter valid(boolean valid) {
        this.context.setNeedValid(valid);
        return this;
    }

    @Deprecated
    public ExcelWriter enableMultiHead() {
        this.context.setMultiHead(true);
        return this;
    }

    @Deprecated
    public ExcelWriter closeMultiHead() {
        this.context.setMultiHead(false);
        return this;
    }

    public ExcelWriter multiHead(boolean multi) {
        this.context.setMultiHead(multi);
        return this;
    }

    public ExcelWriter addListener(ExcelWriteListener listener) {
        if (listener != null) {
            this.context.addListener(listener);
        }
        return this;
    }

    public ExcelWriter addListener(List<? extends ExcelWriteListener> listeners) {
        if (listeners != null) {
            listeners.forEach(this.context::addListener);
        }
        return this;
    }

    public ExcelWriter resetResolver(Supplier<? extends ExcelWriterResolver> excelWriteResolver) {
        this.writerResolver = excelWriteResolver.get();
        return this;
    }

    public ExcelWriter resetExcelClass(Class<?> excelClass, boolean resetListener, String ... ignores) {
        Excel excel = excelClass.getAnnotation(Excel.class);
        ParamUtils.requireNonNull(excel, "Failed to reset Excel class, the @Excel annotation was not found on the " + excelClass);
        ArrayList<String[]> headNames = new ArrayList<String[]>();
        this.context.setExcelFields(BeanUtils.getExcelFields(excelClass, ignores, headNames));
        this.context.setHeadNames(headNames);
        if (resetListener) {
            this.context.getWriteListenerCache().clear();
        }
        return this;
    }

    public void flush() {
        ListenerChain.doWorkbookFlushBefore(this.context);
        this.writerResolver.flush(this.response, this.context);
        if (this.context.getWorkbook() instanceof SXSSFWorkbook) {
            ((SXSSFWorkbook)this.context.getWorkbook()).dispose();
        }
    }

    private void createSheet(String sheetName) {
        Sheet sheet = this.context.getWorkbook().getSheet(sheetName);
        if (sheet == null) {
            sheet = this.context.getWorkbook().createSheet(sheetName);
            this.context.setSheet(sheet);
            ListenerChain.doCompleteSheet(sheet, this.context);
        }
    }
}

