/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.util;

import cn.gjing.tools.excel.ExcelField;
import cn.gjing.tools.excel.util.ParamUtils;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public final class BeanUtils {
    public static void setFieldValue(Object o, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(o, value);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static Object getFieldValue(Object o, Field field) {
        try {
            field.setAccessible(true);
            return field.get(o);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static List<Field> getExcelFields(Class<?> excelClass, String[] ignores, List<String[]> headerArr) {
        Field[] declaredFields = excelClass.getDeclaredFields();
        List<Field> fieldList = new ArrayList<Field>(Arrays.asList(declaredFields));
        for (Class<?> superclass = excelClass.getSuperclass(); superclass != Object.class; superclass = superclass.getSuperclass()) {
            fieldList.addAll(Arrays.asList(superclass.getDeclaredFields()));
        }
        fieldList = fieldList.stream().filter(e -> e.isAnnotationPresent(ExcelField.class)).sorted(Comparator.comparing(e -> e.getAnnotation(ExcelField.class).order())).filter(e -> {
            String[] headNames;
            boolean noContain = true;
            for (String name : headNames = e.getAnnotation(ExcelField.class).value()) {
                if (ParamUtils.noContains(ignores, name)) {
                    if (headerArr == null) break;
                    headerArr.add(headNames);
                    break;
                }
                noContain = false;
            }
            return noContain;
        }).collect(Collectors.toList());
        return fieldList;
    }

    public static Class<?> getInterfaceType(Class<?> source, Class<?> typeInterface, int paramIndex) {
        Type[] genericInterfaces;
        for (Type type : genericInterfaces = source.getGenericInterfaces()) {
            if (!type.getTypeName().startsWith(typeInterface.getName())) continue;
            ParameterizedType pt = (ParameterizedType)type;
            return (Class)pt.getActualTypeArguments()[paramIndex];
        }
        return null;
    }

    public static Enum<?> getEnum(Class<? extends Enum<?>> enumClass, String value) {
        Enum<?>[] enumConstants;
        for (Enum<?> constant : enumConstants = enumClass.getEnumConstants()) {
            if (!value.equals(constant.name())) continue;
            return constant;
        }
        throw new NullPointerException("Not found your enum");
    }
}

