/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.read.resolver;

import cn.gjing.tools.excel.Excel;
import cn.gjing.tools.excel.exception.ExcelInitException;
import cn.gjing.tools.excel.metadata.ExcelReaderResolver;
import cn.gjing.tools.excel.read.ExcelReaderContext;
import cn.gjing.tools.excel.read.listener.ExcelReadListener;
import cn.gjing.tools.excel.read.listener.ExcelResultReadListener;
import cn.gjing.tools.excel.read.resolver.ReadExecutor;
import com.monitorjbl.xlsx.StreamingReader;
import java.io.IOException;
import java.util.List;
import java.util.function.Supplier;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelReader<R> {
    private ExcelReaderContext<R> context;
    private ExcelReaderResolver<R> readerResolver;
    private final String defaultSheetName = "Sheet1";

    private ExcelReader() {
    }

    public ExcelReader(ExcelReaderContext<R> context, Excel excel) {
        this.context = context;
        this.chooseResolver(excel);
    }

    private void chooseResolver(Excel excel) {
        switch (excel.type()) {
            case XLS: {
                try {
                    this.context.setWorkbook((Workbook)new HSSFWorkbook(this.context.getInputStream()));
                    break;
                }
                catch (IOException e) {
                    throw new ExcelInitException("Init workbook error, " + e.getMessage());
                }
            }
            case XLSX: {
                Workbook workbook = StreamingReader.builder().rowCacheSize(excel.cacheRowSize()).bufferSize(excel.bufferSize()).open(this.context.getInputStream());
                this.context.setWorkbook(workbook);
                break;
            }
            default: {
                throw new ExcelInitException("No corresponding resolver was found");
            }
        }
        this.readerResolver = new ReadExecutor();
        this.readerResolver.init(this.context);
    }

    public ExcelReader<R> read() {
        this.readerResolver.read(0, this.defaultSheetName);
        return this;
    }

    public ExcelReader<R> read(String sheetName) {
        this.readerResolver.read(0, sheetName);
        return this;
    }

    public ExcelReader<R> read(int headerIndex) {
        this.readerResolver.read(headerIndex, this.defaultSheetName);
        return this;
    }

    public ExcelReader<R> read(int headerIndex, String sheetName) {
        this.readerResolver.read(headerIndex, sheetName);
        return this;
    }

    public ExcelReader<R> resetResolver(Supplier<? extends ExcelReaderResolver<R>> excelReaderResolver) {
        this.readerResolver = excelReaderResolver.get();
        this.readerResolver.init(this.context);
        return this;
    }

    public ExcelReader<R> addListener(List<ExcelReadListener> readListenerList) {
        readListenerList.forEach(this.context::addListener);
        return this;
    }

    public ExcelReader<R> addListener(ExcelReadListener readListener) {
        this.context.addListener(readListener);
        return this;
    }

    public ExcelReader<R> subscribe(ExcelResultReadListener<R> excelResultReadListener) {
        this.context.setResultReadListener(excelResultReadListener);
        return this;
    }

    public ExcelReader<R> metaInfo(boolean need, boolean checkTemplate) {
        this.context.setNeedMetaInfo(need);
        this.context.setTemplateCheck(checkTemplate);
        return this;
    }

    @Deprecated
    public void end() {
        this.finish();
    }

    public void finish() {
        try {
            if (this.context.getInputStream() != null) {
                this.context.getInputStream().close();
            }
            if (this.context.getWorkbook() != null) {
                this.context.getWorkbook().close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

