/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.write.resolver;

import cn.gjing.tools.excel.ExcelField;
import cn.gjing.tools.excel.convert.DataConvert;
import cn.gjing.tools.excel.convert.DefaultDataConvert;
import cn.gjing.tools.excel.convert.ExcelDataConvert;
import cn.gjing.tools.excel.exception.ExcelInitException;
import cn.gjing.tools.excel.exception.ExcelResolverException;
import cn.gjing.tools.excel.util.BeanUtils;
import cn.gjing.tools.excel.util.ExcelUtils;
import cn.gjing.tools.excel.util.ListenerChain;
import cn.gjing.tools.excel.util.ParamUtils;
import cn.gjing.tools.excel.write.BigTitle;
import cn.gjing.tools.excel.write.ExcelWriterContext;
import cn.gjing.tools.excel.write.callback.ExcelAutoMergeCallback;
import cn.gjing.tools.excel.write.listener.ExcelCascadingDropdownBoxListener;
import cn.gjing.tools.excel.write.listener.ExcelCellWriteListener;
import cn.gjing.tools.excel.write.listener.ExcelWriteListener;
import cn.gjing.tools.excel.write.merge.ExcelOldCellModel;
import cn.gjing.tools.excel.write.merge.ExcelOldRowModel;
import cn.gjing.tools.excel.write.style.ExcelStyleWriteListener;
import cn.gjing.tools.excel.write.valid.ExcelDateValid;
import cn.gjing.tools.excel.write.valid.ExcelDropdownBox;
import cn.gjing.tools.excel.write.valid.ExcelNumericValid;
import com.google.gson.Gson;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

class WriteExecutor {
    private final ExcelWriterContext context;
    private Map<String, DataConvert<?>> dataConvertMap;
    private Map<String, ExcelAutoMergeCallback<?>> mergeCallbackMap;
    private Map<Integer, ExcelOldRowModel> oldRowModelMap;
    private final Gson gson = new Gson();

    public WriteExecutor(ExcelWriterContext context) {
        this.context = context;
    }

    public void setBigTitle(BigTitle bigTitle) {
        List<ExcelWriteListener> cellListeners = this.context.getWriteListenerCache().get(ExcelCellWriteListener.class);
        int startOffset = this.context.getSheet().getPhysicalNumberOfRows();
        int endOffset = startOffset + bigTitle.getLines() - 1;
        for (int i = 0; i < bigTitle.getLines(); ++i) {
            Row row = this.context.getSheet().createRow(startOffset + i);
            for (int j = bigTitle.getFirstCol(); j < bigTitle.getLastCols(); ++j) {
                Cell cell = row.createCell(j);
                cell.setCellValue(bigTitle.getContent());
                cellListeners.forEach(e -> {
                    if (e instanceof ExcelStyleWriteListener) {
                        ((ExcelStyleWriteListener)e).setTitleStyle(cell);
                    }
                });
            }
        }
        this.context.getSheet().addMergedRegion(new CellRangeAddress(startOffset, endOffset, bigTitle.getFirstCol(), bigTitle.getLastCols()));
    }

    public void setHead(boolean needHead, Map<String, String[]> boxValues) {
        if (this.context.getHeadNames().isEmpty()) {
            return;
        }
        if (needHead) {
            int rowIndex = this.context.getSheet().getLastRowNum() == 0 ? 0 : this.context.getSheet().getLastRowNum() + 1;
            ExcelOldCellModel oldCellModel = null;
            int headRowSize = this.context.getHeadNames().get(0).length;
            for (int index = 0; index < headRowSize; ++index) {
                Row headRow = this.context.getSheet().createRow(rowIndex + index);
                int headSize = this.context.getHeadNames().size();
                for (int colIndex = 0; colIndex < headSize; ++colIndex) {
                    Field field = this.context.getExcelFields().get(colIndex);
                    ExcelField excelField = field.getAnnotation(ExcelField.class);
                    String headName = this.context.getHeadNames().get(colIndex)[index];
                    Cell headCell = headRow.createCell(colIndex);
                    headCell.setCellValue(headName);
                    if (this.context.getMultiHead().booleanValue()) {
                        if (oldCellModel == null) {
                            oldCellModel = new ExcelOldCellModel();
                        }
                        if (this.oldRowModelMap == null) {
                            this.oldRowModelMap = new HashMap<Integer, ExcelOldRowModel>(12);
                        }
                        try {
                            ExcelUtils.mergeX(oldCellModel, this.context.getSheet(), headRow, excelField.autoMerge().empty(), colIndex, headName, headSize, true);
                            ExcelUtils.mergeY(this.oldRowModelMap, this.context.getSheet(), headRow, excelField.autoMerge().empty(), index, colIndex, headName, headRowSize, true);
                        }
                        catch (Exception e) {
                            throw new ExcelResolverException("Auto merge failure, " + e.getMessage());
                        }
                    }
                    if (this.context.getNeedValid().booleanValue() && index == headRowSize - 1) {
                        try {
                            this.addValid(field, headRow, colIndex, boxValues);
                        }
                        catch (Exception e) {
                            throw new ExcelResolverException("Add excel validation failure, " + e.getMessage());
                        }
                    }
                    ListenerChain.doCompleteCell(this.context.getWriteListenerCache(), this.context.getSheet(), headRow, headCell, excelField, field, headName, index, colIndex, true, headName);
                }
                ListenerChain.doCompleteRow(this.context.getWriteListenerCache(), this.context.getSheet(), headRow, rowIndex, true);
            }
        }
    }

    public void setValue(List<?> data) {
        if (data == null) {
            return;
        }
        int rowIndex = this.context.getSheet().getLastRowNum() + 1;
        SpelExpressionParser parser = new SpelExpressionParser();
        StandardEvaluationContext context = new StandardEvaluationContext();
        int dataSize = data.size();
        for (int index = 0; index < dataSize; ++index) {
            Object o = data.get(index);
            context.setVariable(o.getClass().getSimpleName(), o);
            Row valueRow = this.context.getSheet().createRow(rowIndex + index);
            int headSize = this.context.getExcelFields().size();
            for (int colIndex = 0; colIndex < headSize; ++colIndex) {
                Field field = this.context.getExcelFields().get(colIndex);
                ExcelField excelField = field.getAnnotation(ExcelField.class);
                DataConvert<?> dataConvert = this.createDataConvert(field, excelField);
                ExcelDataConvert excelDataConvert = field.getAnnotation(ExcelDataConvert.class);
                Object value = BeanUtils.getFieldValue(o, field);
                Cell valueCell = valueRow.createCell(colIndex);
                context.setVariable(field.getName(), value);
                try {
                    value = this.convert(field, value, o, (ExpressionParser)parser, excelDataConvert, (EvaluationContext)context, dataConvert);
                    if (excelField.autoMerge().open()) {
                        ExcelAutoMergeCallback<?> autoMergeCallback = this.createMergeCallback(field, excelField);
                        this.autoMergeY(autoMergeCallback, valueRow, field, excelField, index, colIndex, value, o, dataSize);
                    }
                    ExcelUtils.setCellValue(valueCell, value, field);
                    ListenerChain.doCompleteCell(this.context.getWriteListenerCache(), this.context.getSheet(), valueRow, valueCell, excelField, field, null, index, colIndex, false, value);
                    continue;
                }
                catch (Exception e) {
                    throw new ExcelResolverException(e.getMessage());
                }
            }
            ListenerChain.doCompleteRow(this.context.getWriteListenerCache(), this.context.getSheet(), valueRow, index, false);
        }
    }

    private DataConvert<?> createDataConvert(Field field, ExcelField excelField) {
        DataConvert<?> dataConvert = null;
        if (excelField.convert() != DefaultDataConvert.class) {
            if (this.dataConvertMap == null) {
                this.dataConvertMap = new HashMap(10);
            }
            if ((dataConvert = this.dataConvertMap.get(field.getName())) == null) {
                try {
                    dataConvert = excelField.convert().newInstance();
                    this.dataConvertMap.put(field.getName(), dataConvert);
                }
                catch (Exception e) {
                    throw new ExcelInitException("Init specified excel header data converter failure " + field.getName() + ", " + e.getMessage());
                }
            }
        }
        return dataConvert;
    }

    private ExcelAutoMergeCallback<?> createMergeCallback(Field field, ExcelField excelField) {
        ExcelAutoMergeCallback<?> autoMergeCallback;
        if (this.mergeCallbackMap == null) {
            this.mergeCallbackMap = new HashMap(12);
            if (this.oldRowModelMap == null) {
                this.oldRowModelMap = new HashMap<Integer, ExcelOldRowModel>(12);
            }
        }
        if ((autoMergeCallback = this.mergeCallbackMap.get(field.getName())) == null) {
            try {
                autoMergeCallback = excelField.autoMerge().callback().newInstance();
                this.mergeCallbackMap.put(field.getName(), autoMergeCallback);
            }
            catch (Exception e) {
                throw new ExcelInitException("Init specified excel header merge callback failure " + field.getName() + ", " + e.getMessage());
            }
        }
        return autoMergeCallback;
    }

    private void autoMergeY(ExcelAutoMergeCallback<?> autoMergeCallback, Row row, Field field, ExcelField excelField, int index, int colIndex, Object cellValue, Object obj, int dataSize) {
        if (index == 0) {
            autoMergeCallback.mergeY(obj == null ? null : this.gson.fromJson(this.gson.toJson(obj), obj.getClass()), field, colIndex, index);
            this.oldRowModelMap.put(colIndex, new ExcelOldRowModel(cellValue, row.getRowNum()));
            return;
        }
        ExcelOldRowModel excelOldRowModel = this.oldRowModelMap.get(colIndex);
        if (autoMergeCallback.mergeY(obj == null ? null : this.gson.fromJson(this.gson.toJson(obj), obj.getClass()), field, colIndex, index)) {
            if (ParamUtils.equals(cellValue, excelOldRowModel.getOldRowCellValue(), excelField.autoMerge().empty())) {
                if (index == dataSize - 1) {
                    this.context.getSheet().addMergedRegion(new CellRangeAddress(excelOldRowModel.getOldRowIndex(), row.getRowNum(), colIndex, colIndex));
                }
                return;
            }
            if (excelOldRowModel.getOldRowIndex() + 1 < row.getRowNum()) {
                this.context.getSheet().addMergedRegion(new CellRangeAddress(excelOldRowModel.getOldRowIndex(), row.getRowNum() - 1, colIndex, colIndex));
            }
            if (index != dataSize - 1) {
                this.oldRowModelMap.put(colIndex, new ExcelOldRowModel(cellValue, row.getRowNum()));
            }
            return;
        }
        if (excelOldRowModel.getOldRowIndex() + 1 < row.getRowNum()) {
            this.context.getSheet().addMergedRegion(new CellRangeAddress(excelOldRowModel.getOldRowIndex(), row.getRowNum() - 1, colIndex, colIndex));
            excelOldRowModel.setOldRowCellValue(cellValue);
            excelOldRowModel.setOldRowIndex(row.getRowNum());
            this.oldRowModelMap.put(colIndex, excelOldRowModel);
        }
    }

    private Object convert(Field field, Object value, Object obj, ExpressionParser parser, ExcelDataConvert excelDataConvert, EvaluationContext context, DataConvert<?> dataConvert) {
        if (excelDataConvert != null && !"".equals(excelDataConvert.expr1())) {
            return parser.parseExpression(excelDataConvert.expr1()).getValue(context);
        }
        if (dataConvert != null) {
            return dataConvert.toExcelAttribute(this.gson.fromJson(this.gson.toJson(obj), obj.getClass()), value, field);
        }
        return value;
    }

    private void addValid(Field field, Row row, int colIndex, Map<String, String[]> boxValues) {
        ExcelDropdownBox ev = field.getAnnotation(ExcelDropdownBox.class);
        ExcelDateValid dv = field.getAnnotation(ExcelDateValid.class);
        ExcelNumericValid nv = field.getAnnotation(ExcelNumericValid.class);
        int firstRow = row.getRowNum() + 1;
        if (ev != null) {
            if ("".equals(ev.link())) {
                ExcelUtils.addDropdownBox(ev.combobox(), ev.showErrorBox(), ev.rank(), ev.errorTitle(), ev.errorContent(), this.context.getWorkbook(), this.context.getSheet(), firstRow, ev.rows() == 0 ? firstRow : ev.rows() + firstRow - 1, colIndex, boxValues == null ? null : boxValues.get(field.getName()));
            } else {
                List<ExcelWriteListener> dropdownListeners = this.context.getWriteListenerCache().get(ExcelCascadingDropdownBoxListener.class);
                if (dropdownListeners == null) {
                    return;
                }
                dropdownListeners.forEach(e -> ((ExcelCascadingDropdownBoxListener)e).addCascadingDropdownBox(ev, this.context.getWorkbook(), this.context.getSheet(), firstRow, ev.rows() == 0 ? firstRow : ev.rows() + firstRow - 1, colIndex, field));
            }
        }
        if (dv != null) {
            ExcelUtils.addDateValid(dv.operatorType(), dv.expr1(), dv.expr2(), dv.pattern(), this.context.getSheet(), firstRow, dv.rows() == 0 ? firstRow : dv.rows() + firstRow - 1, colIndex, dv.showErrorBox(), dv.rank(), dv.errorTitle(), dv.errorContent(), dv.showTip(), dv.tipTitle(), dv.tipContent());
        }
        if (nv != null) {
            ExcelUtils.addNumericValid(nv.validType(), nv.operatorType(), nv.expr1(), nv.expr2(), this.context.getSheet(), firstRow, nv.rows() == 0 ? firstRow : nv.rows() + firstRow - 1, colIndex, nv.showErrorBox(), nv.rank(), nv.errorTitle(), nv.errorContent(), nv.showTip(), nv.tipTitle(), nv.tipContent());
        }
    }
}

