/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.write;

import cn.gjing.tools.excel.util.ListenerChain;
import cn.gjing.tools.excel.write.listener.ExcelWriteListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public final class ExcelWriterContext {
    private Workbook workbook;
    private Sheet sheet;
    private String fileName;
    private Boolean needValid;
    private Boolean multiHead;
    private List<Field> excelFields;
    private List<String[]> headNames;
    private Map<Class<? extends ExcelWriteListener>, List<ExcelWriteListener>> writeListenerCache;

    public ExcelWriterContext addListener(ExcelWriteListener excelWriteListener) {
        ListenerChain.addWriteListener(this.writeListenerCache, excelWriteListener, this.workbook);
        return this;
    }

    private static Boolean $default$needValid() {
        return false;
    }

    private static Boolean $default$multiHead() {
        return false;
    }

    private static List<Field> $default$excelFields() {
        return new ArrayList<Field>();
    }

    private static List<String[]> $default$headNames() {
        return new ArrayList<String[]>();
    }

    private static Map<Class<? extends ExcelWriteListener>, List<ExcelWriteListener>> $default$writeListenerCache() {
        return new HashMap<Class<? extends ExcelWriteListener>, List<ExcelWriteListener>>(8);
    }

    public static ExcelWriterContextBuilder builder() {
        return new ExcelWriterContextBuilder();
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Boolean getNeedValid() {
        return this.needValid;
    }

    public Boolean getMultiHead() {
        return this.multiHead;
    }

    public List<Field> getExcelFields() {
        return this.excelFields;
    }

    public List<String[]> getHeadNames() {
        return this.headNames;
    }

    public Map<Class<? extends ExcelWriteListener>, List<ExcelWriteListener>> getWriteListenerCache() {
        return this.writeListenerCache;
    }

    public void setWorkbook(Workbook workbook) {
        this.workbook = workbook;
    }

    public void setSheet(Sheet sheet) {
        this.sheet = sheet;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setNeedValid(Boolean needValid) {
        this.needValid = needValid;
    }

    public void setMultiHead(Boolean multiHead) {
        this.multiHead = multiHead;
    }

    public void setExcelFields(List<Field> excelFields) {
        this.excelFields = excelFields;
    }

    public void setHeadNames(List<String[]> headNames) {
        this.headNames = headNames;
    }

    public void setWriteListenerCache(Map<Class<? extends ExcelWriteListener>, List<ExcelWriteListener>> writeListenerCache) {
        this.writeListenerCache = writeListenerCache;
    }

    public ExcelWriterContext() {
        this.needValid = ExcelWriterContext.$default$needValid();
        this.multiHead = ExcelWriterContext.$default$multiHead();
        this.excelFields = ExcelWriterContext.$default$excelFields();
        this.headNames = ExcelWriterContext.$default$headNames();
        this.writeListenerCache = ExcelWriterContext.$default$writeListenerCache();
    }

    public ExcelWriterContext(Workbook workbook, Sheet sheet, String fileName, Boolean needValid, Boolean multiHead, List<Field> excelFields, List<String[]> headNames, Map<Class<? extends ExcelWriteListener>, List<ExcelWriteListener>> writeListenerCache) {
        this.workbook = workbook;
        this.sheet = sheet;
        this.fileName = fileName;
        this.needValid = needValid;
        this.multiHead = multiHead;
        this.excelFields = excelFields;
        this.headNames = headNames;
        this.writeListenerCache = writeListenerCache;
    }

    public static class ExcelWriterContextBuilder {
        private Workbook workbook;
        private Sheet sheet;
        private String fileName;
        private boolean needValid$set;
        private Boolean needValid$value;
        private boolean multiHead$set;
        private Boolean multiHead$value;
        private boolean excelFields$set;
        private List<Field> excelFields$value;
        private boolean headNames$set;
        private List<String[]> headNames$value;
        private boolean writeListenerCache$set;
        private Map<Class<? extends ExcelWriteListener>, List<ExcelWriteListener>> writeListenerCache$value;

        ExcelWriterContextBuilder() {
        }

        public ExcelWriterContextBuilder workbook(Workbook workbook) {
            this.workbook = workbook;
            return this;
        }

        public ExcelWriterContextBuilder sheet(Sheet sheet) {
            this.sheet = sheet;
            return this;
        }

        public ExcelWriterContextBuilder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public ExcelWriterContextBuilder needValid(Boolean needValid) {
            this.needValid$value = needValid;
            this.needValid$set = true;
            return this;
        }

        public ExcelWriterContextBuilder multiHead(Boolean multiHead) {
            this.multiHead$value = multiHead;
            this.multiHead$set = true;
            return this;
        }

        public ExcelWriterContextBuilder excelFields(List<Field> excelFields) {
            this.excelFields$value = excelFields;
            this.excelFields$set = true;
            return this;
        }

        public ExcelWriterContextBuilder headNames(List<String[]> headNames) {
            this.headNames$value = headNames;
            this.headNames$set = true;
            return this;
        }

        public ExcelWriterContextBuilder writeListenerCache(Map<Class<? extends ExcelWriteListener>, List<ExcelWriteListener>> writeListenerCache) {
            this.writeListenerCache$value = writeListenerCache;
            this.writeListenerCache$set = true;
            return this;
        }

        public ExcelWriterContext build() {
            Boolean needValid$value = this.needValid$value;
            if (!this.needValid$set) {
                needValid$value = ExcelWriterContext.$default$needValid();
            }
            Boolean multiHead$value = this.multiHead$value;
            if (!this.multiHead$set) {
                multiHead$value = ExcelWriterContext.$default$multiHead();
            }
            List excelFields$value = this.excelFields$value;
            if (!this.excelFields$set) {
                excelFields$value = ExcelWriterContext.$default$excelFields();
            }
            List headNames$value = this.headNames$value;
            if (!this.headNames$set) {
                headNames$value = ExcelWriterContext.$default$headNames();
            }
            Map writeListenerCache$value = this.writeListenerCache$value;
            if (!this.writeListenerCache$set) {
                writeListenerCache$value = ExcelWriterContext.$default$writeListenerCache();
            }
            return new ExcelWriterContext(this.workbook, this.sheet, this.fileName, needValid$value, multiHead$value, excelFields$value, headNames$value, writeListenerCache$value);
        }

        public String toString() {
            return "ExcelWriterContext.ExcelWriterContextBuilder(workbook=" + this.workbook + ", sheet=" + this.sheet + ", fileName=" + this.fileName + ", needValid$value=" + this.needValid$value + ", multiHead$value=" + this.multiHead$value + ", excelFields$value=" + this.excelFields$value + ", headNames$value=" + this.headNames$value + ", writeListenerCache$value=" + this.writeListenerCache$value + ")";
        }
    }
}

