/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.util;

import cn.gjing.tools.excel.exception.ExcelResolverException;
import java.util.Iterator;
import java.util.Map;

public final class ParamUtils {
    public static boolean noContains(String[] arr, String val) {
        if (arr == null || arr.length == 0) {
            return true;
        }
        for (String o : arr) {
            if (!o.equals(val)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object param1, Object param2, boolean allowEmpty) {
        if (allowEmpty) {
            if (param1 == param2) {
                return true;
            }
            return param1 != null && param1.equals(param2);
        }
        if (param1 == null || "".equals(param1)) {
            return false;
        }
        return param1 == param2 || param1.equals(param2);
    }

    public static <T> void requireNonNull(T obj, String message) {
        if (obj == null) {
            throw new ExcelResolverException(message);
        }
    }

    public static String createFormula(int offset, int rowIndex, int colCount) {
        char endSuffix;
        char start = (char)(65 + offset);
        if (colCount <= 25) {
            if (colCount == 0) {
                return "$" + start + "$" + rowIndex;
            }
            char end = (char)(start + colCount - 1);
            return "$" + start + "$" + rowIndex + ":$" + end + "$" + rowIndex;
        }
        char endPrefix = 'A';
        if ((colCount - 25) / 26 == 0 || colCount == 51) {
            endSuffix = (colCount - 25) % 26 == 0 ? (char)'Z' : (char)((char)(65 + (colCount - 25) % 26 - 1));
        } else if ((colCount - 25) % 26 == 0) {
            endSuffix = 'Z';
            endPrefix = (char)(endPrefix + (colCount - 25) / 26 - 1);
        } else {
            endSuffix = (char)(65 + (colCount - 25) % 26 - 1);
            endPrefix = (char)(endPrefix + (colCount - 25) / 26);
        }
        return "$" + start + "$" + rowIndex + ":$" + endPrefix + endSuffix + "$" + rowIndex;
    }

    public static void deleteMapKey(Map<?, ?> map, String key) {
        Iterator<Map.Entry<?, ?>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<?, ?> next = iterator.next();
            if (!next.getKey().equals(key)) continue;
            iterator.remove();
            break;
        }
    }
}

