/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.util;

import cn.gjing.tools.excel.ExcelField;
import cn.gjing.tools.excel.read.listener.ExcelEmptyReadListener;
import cn.gjing.tools.excel.read.listener.ExcelReadListener;
import cn.gjing.tools.excel.read.listener.ExcelResultReadListener;
import cn.gjing.tools.excel.read.listener.ExcelRowReadListener;
import cn.gjing.tools.excel.write.ExcelWriterContext;
import cn.gjing.tools.excel.write.listener.ExcelCascadingDropdownBoxListener;
import cn.gjing.tools.excel.write.listener.ExcelCellWriteListener;
import cn.gjing.tools.excel.write.listener.ExcelRowWriteListener;
import cn.gjing.tools.excel.write.listener.ExcelSheetWriteListener;
import cn.gjing.tools.excel.write.listener.ExcelWorkbookWriteListener;
import cn.gjing.tools.excel.write.listener.ExcelWriteListener;
import cn.gjing.tools.excel.write.style.ExcelStyleWriteListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public final class ListenerChain {
    public static void doCompleteCell(Map<Class<? extends ExcelWriteListener>, List<ExcelWriteListener>> excelListeners, Sheet sheet, Row row, Cell cell, ExcelField excelField, Field field, String headName, int index, int colIndex, boolean isHead, Object value) {
        List<ExcelWriteListener> cellListeners = excelListeners.get(ExcelCellWriteListener.class);
        if (cellListeners != null) {
            cellListeners.forEach(e -> ((ExcelCellWriteListener)e).completeCell(sheet, row, cell, excelField, field, headName, index, colIndex, isHead, value));
        }
    }

    public static void doCompleteRow(Map<Class<? extends ExcelWriteListener>, List<ExcelWriteListener>> excelListeners, Sheet sheet, Row row, int index, boolean isHead) {
        List<ExcelWriteListener> rowListeners = excelListeners.get(ExcelRowWriteListener.class);
        if (rowListeners != null) {
            rowListeners.forEach(e -> ((ExcelRowWriteListener)e).completeRow(sheet, row, index, isHead));
        }
    }

    public static void doCompleteSheet(ExcelWriterContext context) {
        List<ExcelWriteListener> sheetListeners = context.getWriteListenerCache().get(ExcelSheetWriteListener.class);
        if (sheetListeners != null) {
            sheetListeners.forEach(e -> ((ExcelSheetWriteListener)e).completeSheet(context));
        }
    }

    public static void doWorkbookFlushBefore(ExcelWriterContext context) {
        List<ExcelWriteListener> workbookListeners = context.getWriteListenerCache().get(ExcelWorkbookWriteListener.class);
        if (workbookListeners != null) {
            workbookListeners.forEach(e -> ((ExcelWorkbookWriteListener)e).flushBefore(context));
        }
    }

    public static <R> boolean doReadRow(List<ExcelReadListener> rowReadListeners, R r, List<String> headNames, int rowIndex, boolean isHead, boolean hasNext) {
        boolean stop = false;
        if (rowReadListeners != null) {
            for (ExcelReadListener rowReadListener : rowReadListeners) {
                stop = ((ExcelRowReadListener)rowReadListener).readRow(r, headNames, rowIndex, isHead, hasNext);
            }
        }
        return stop;
    }

    public static <R> void doReadCell(List<ExcelReadListener> rowReadListeners, R r, Object cellValue, Field field, int rowIndex, int colIndex, boolean isHead) {
        if (rowReadListeners != null) {
            rowReadListeners.forEach(e -> ((ExcelRowReadListener)e).readCell(r, cellValue, field, rowIndex, colIndex, isHead));
        }
    }

    public static <R> boolean doReadEmpty(List<ExcelReadListener> emptyReadListeners, R r, Field field, ExcelField excelField, int rowIndex, int colIndex, boolean hasNext) {
        boolean isSave = false;
        if (emptyReadListeners != null) {
            for (ExcelReadListener emptyReadListener : emptyReadListeners) {
                isSave = ((ExcelEmptyReadListener)emptyReadListener).readEmpty(r, field, excelField, rowIndex, colIndex, hasNext);
            }
        }
        return isSave;
    }

    public static <R> void doResultNotify(ExcelResultReadListener<R> resultReadListener, List<R> data) {
        if (data != null) {
            resultReadListener.notify(data);
        }
    }

    public static void addWriteListener(Map<Class<? extends ExcelWriteListener>, List<ExcelWriteListener>> writeListenerCache, ExcelWriteListener listener, Workbook workbook) {
        List listeners;
        if (listener instanceof ExcelStyleWriteListener) {
            ((ExcelStyleWriteListener)listener).init(workbook);
        }
        if (listener instanceof ExcelSheetWriteListener) {
            listeners = writeListenerCache.computeIfAbsent(ExcelSheetWriteListener.class, k -> new ArrayList());
            listeners.add(listener);
        }
        if (listener instanceof ExcelRowWriteListener) {
            listeners = writeListenerCache.computeIfAbsent(ExcelRowWriteListener.class, k -> new ArrayList());
            listeners.add(listener);
        }
        if (listener instanceof ExcelCellWriteListener) {
            listeners = writeListenerCache.computeIfAbsent(ExcelCellWriteListener.class, k -> new ArrayList());
            listeners.add(listener);
        }
        if (listener instanceof ExcelCascadingDropdownBoxListener) {
            listeners = writeListenerCache.computeIfAbsent(ExcelCascadingDropdownBoxListener.class, k -> new ArrayList());
            listeners.add(listener);
        }
        if (listener instanceof ExcelWorkbookWriteListener) {
            listeners = writeListenerCache.computeIfAbsent(ExcelWorkbookWriteListener.class, k -> new ArrayList());
            listeners.add(listener);
        }
    }

    public static void addReadListener(Map<Class<? extends ExcelReadListener>, List<ExcelReadListener>> readListenersCache, ExcelReadListener readListener) {
        List readListeners;
        if (readListener instanceof ExcelRowReadListener) {
            readListeners = readListenersCache.computeIfAbsent(ExcelRowReadListener.class, k -> new ArrayList());
            readListeners.add(readListener);
        }
        if (readListener instanceof ExcelEmptyReadListener) {
            readListeners = readListenersCache.computeIfAbsent(ExcelEmptyReadListener.class, k -> new ArrayList());
            readListeners.add(readListener);
        }
    }
}

