/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.read.resolver;

import cn.gjing.tools.excel.ExcelField;
import cn.gjing.tools.excel.convert.DataConvert;
import cn.gjing.tools.excel.convert.DefaultDataConvert;
import cn.gjing.tools.excel.convert.ExcelDataConvert;
import cn.gjing.tools.excel.exception.ExcelAssertException;
import cn.gjing.tools.excel.exception.ExcelInitException;
import cn.gjing.tools.excel.exception.ExcelResolverException;
import cn.gjing.tools.excel.exception.ExcelTemplateException;
import cn.gjing.tools.excel.metadata.ExcelReaderResolver;
import cn.gjing.tools.excel.read.ExcelReaderContext;
import cn.gjing.tools.excel.read.listener.ExcelEmptyReadListener;
import cn.gjing.tools.excel.read.listener.ExcelReadListener;
import cn.gjing.tools.excel.read.listener.ExcelRowReadListener;
import cn.gjing.tools.excel.read.valid.ExcelAssert;
import cn.gjing.tools.excel.util.BeanUtils;
import cn.gjing.tools.excel.util.ListenerChain;
import com.google.gson.Gson;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

class ReadExecutor<R>
implements ExcelReaderResolver<R> {
    private ExcelReaderContext<R> context;
    private Map<String, DataConvert<?>> dataConvertMap;
    private Boolean isSave;

    ReadExecutor() {
    }

    @Override
    public void init(ExcelReaderContext<R> readerContext) {
        this.context = readerContext;
    }

    @Override
    public void read(int startIndex, String sheetName) {
        this.context.getExcelFields().forEach(e -> {
            ExcelField excelField = e.getAnnotation(ExcelField.class);
            if (excelField.convert() != DefaultDataConvert.class) {
                if (this.dataConvertMap == null) {
                    this.dataConvertMap = new HashMap(16);
                }
                try {
                    this.dataConvertMap.put(e.getName(), excelField.convert().newInstance());
                }
                catch (Exception ex) {
                    throw new ExcelInitException("Init specified excel header data converter error " + e.getName() + ", " + ex.getMessage());
                }
            }
        });
        Sheet sheet = this.context.getWorkbook().getSheet(sheetName);
        if (sheet == null) {
            throw new ExcelResolverException("The" + sheetName + " is not found in the workbook");
        }
        this.context.setSheet(sheet);
        this.reader(startIndex, this.context.getResultReadListener() == null ? null : new ArrayList());
    }

    private void reader(int startIndex, List<R> dataList) {
        this.isSave = true;
        boolean stop = false;
        SpelExpressionParser parser = new SpelExpressionParser();
        StandardEvaluationContext context = new StandardEvaluationContext();
        List<ExcelReadListener> rowReadListeners = this.context.getReadListenersCache().get(ExcelRowReadListener.class);
        Gson gson = new Gson();
        for (Row row : this.context.getSheet()) {
            R r;
            boolean hasNext;
            if (stop) break;
            boolean bl = hasNext = row.getRowNum() < this.context.getSheet().getLastRowNum();
            if (row.getRowNum() < startIndex) continue;
            if (row.getRowNum() == startIndex) {
                if (row.getLastCellNum() != this.context.getExcelFields().size()) {
                    throw new ExcelTemplateException();
                }
                if (!this.context.getHeadNames().isEmpty()) continue;
                for (Cell cell : row) {
                    this.context.getHeadNames().add(cell.getStringCellValue());
                    ListenerChain.doReadCell(rowReadListeners, null, cell.getStringCellValue(), null, startIndex, cell.getColumnIndex(), true);
                }
                stop = ListenerChain.doReadRow(rowReadListeners, null, this.context.getHeadNames(), startIndex, true, hasNext);
                continue;
            }
            try {
                r = this.context.getExcelClass().newInstance();
                context.setVariable(this.context.getExcelClass().getSimpleName(), r);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ExcelInitException("Excel entity init failure, " + e.getMessage());
            }
            for (int c = 0; c < row.getLastCellNum() && this.isSave.booleanValue(); ++c) {
                Field field = this.context.getExcelFields().get(c);
                ExcelField excelField = field.getAnnotation(ExcelField.class);
                ExcelAssert excelAssert = field.getAnnotation(ExcelAssert.class);
                ExcelDataConvert excelDataConvert = field.getAnnotation(ExcelDataConvert.class);
                Cell valueCell = row.getCell(c);
                try {
                    Object value;
                    if (valueCell != null) {
                        value = this.getValue(r, valueCell, field, excelField, gson, hasNext);
                        context.setVariable(field.getName(), value);
                        this.assertValue((ExpressionParser)parser, (EvaluationContext)context, row, c, field, excelField, excelAssert);
                        value = this.convert(field, value, (ExpressionParser)parser, excelDataConvert, (EvaluationContext)context);
                        if (this.isSave.booleanValue() && value != null) {
                            this.setValue(r, field, value);
                        }
                    } else {
                        context.setVariable(field.getName(), null);
                        this.allowEmpty(r, field, excelField, row.getRowNum(), c, hasNext);
                        this.assertValue((ExpressionParser)parser, (EvaluationContext)context, row, c, field, excelField, excelAssert);
                        value = this.convert(field, null, (ExpressionParser)parser, excelDataConvert, (EvaluationContext)context);
                        this.setValue(r, field, value);
                    }
                    ListenerChain.doReadCell(rowReadListeners, r, value, field, row.getRowNum(), c, false);
                    context.setVariable(field.getName(), value);
                    continue;
                }
                catch (Exception e) {
                    if (e instanceof ExcelAssertException) {
                        throw (ExcelAssertException)e;
                    }
                    throw new ExcelResolverException(e.getMessage());
                }
            }
            if (!this.isSave.booleanValue()) continue;
            try {
                if (dataList != null) {
                    dataList.add(r);
                }
                ListenerChain.doReadRow(rowReadListeners, r, null, row.getRowNum(), false, hasNext);
            }
            catch (Exception e) {
                throw new ExcelResolverException(e.getMessage());
            }
        }
        ListenerChain.doResultNotify(this.context.getResultReadListener(), dataList);
    }

    private Object getValue(R r, Cell cell, Field field, ExcelField excelField, Gson gson, boolean hasNext) {
        switch (cell.getCellType()) {
            case _NONE: 
            case BLANK: 
            case ERROR: {
                this.allowEmpty(r, field, excelField, cell.getRowIndex(), cell.getColumnIndex(), hasNext);
                break;
            }
            case BOOLEAN: {
                return cell.getBooleanCellValue();
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return cell.getDateCellValue();
                }
                return gson.fromJson(gson.toJson((Object)cell.getNumericCellValue()), field.getType());
            }
            case FORMULA: {
                return cell.getCellFormula();
            }
            default: {
                return cell.getStringCellValue();
            }
        }
        return null;
    }

    private Object convert(Field field, Object value, ExpressionParser parser, ExcelDataConvert excelDataConvert, EvaluationContext context) {
        DataConvert<?> dataConvert;
        if (excelDataConvert != null && !"".equals(excelDataConvert.expr2())) {
            return parser.parseExpression(excelDataConvert.expr2()).getValue(context);
        }
        if (this.dataConvertMap != null && (dataConvert = this.dataConvertMap.get(field.getName())) != null) {
            return dataConvert.toEntityAttribute(value, field);
        }
        return value;
    }

    private void setValue(R o, Field field, Object value) {
        try {
            BeanUtils.setFieldValue(o, field, value);
        }
        catch (RuntimeException e) {
            if (field.getType() == LocalDate.class) {
                BeanUtils.setFieldValue(o, field, LocalDateTime.ofInstant(((Date)value).toInstant(), ZoneId.systemDefault()).toLocalDate());
                return;
            }
            if (field.getType() == LocalDateTime.class) {
                BeanUtils.setFieldValue(o, field, LocalDateTime.ofInstant(((Date)value).toInstant(), ZoneId.systemDefault()));
                return;
            }
            throw new IllegalArgumentException("Unsupported data type, you can use a data converter " + field.getName() + " " + value);
        }
    }

    private void allowEmpty(R r, Field field, ExcelField excelField, int rowIndex, int colIndex, boolean hasNext) {
        if (excelField.allowEmpty()) {
            return;
        }
        this.isSave = ListenerChain.doReadEmpty(this.context.getReadListenersCache().get(ExcelEmptyReadListener.class), r, field, excelField, rowIndex, colIndex, hasNext);
    }

    private void assertValue(ExpressionParser parser, EvaluationContext context, Row row, int c, Field field, ExcelField excelField, ExcelAssert excelAssert) {
        Boolean test;
        if (excelAssert != null && (test = (Boolean)parser.parseExpression(excelAssert.expr()).getValue(context, Boolean.class)) != null && !test.booleanValue()) {
            throw new ExcelAssertException(excelAssert.message(), excelField, field, row.getRowNum(), c);
        }
    }
}

