/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.read;

import cn.gjing.tools.excel.read.listener.ExcelReadListener;
import cn.gjing.tools.excel.read.listener.ExcelResultReadListener;
import cn.gjing.tools.excel.util.ListenerChain;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelReaderContext<R> {
    private Workbook workbook;
    private Sheet sheet;
    private InputStream inputStream;
    private Class<R> excelClass;
    private List<String> headNames = new ArrayList<String>();
    private List<Field> excelFields;
    private Map<Class<? extends ExcelReadListener>, List<ExcelReadListener>> readListenersCache = new HashMap<Class<? extends ExcelReadListener>, List<ExcelReadListener>>(8);
    private ExcelResultReadListener<R> resultReadListener;

    public ExcelReaderContext(InputStream inputStream, Class<R> excelClass, List<Field> excelFields) {
        this.inputStream = inputStream;
        this.excelClass = excelClass;
        this.excelFields = excelFields;
    }

    public ExcelReaderContext<R> addListener(ExcelReadListener readListener) {
        ListenerChain.addReadListener(this.readListenersCache, readListener);
        return this;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public Class<R> getExcelClass() {
        return this.excelClass;
    }

    public List<String> getHeadNames() {
        return this.headNames;
    }

    public List<Field> getExcelFields() {
        return this.excelFields;
    }

    public Map<Class<? extends ExcelReadListener>, List<ExcelReadListener>> getReadListenersCache() {
        return this.readListenersCache;
    }

    public ExcelResultReadListener<R> getResultReadListener() {
        return this.resultReadListener;
    }

    public void setWorkbook(Workbook workbook) {
        this.workbook = workbook;
    }

    public void setSheet(Sheet sheet) {
        this.sheet = sheet;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void setExcelClass(Class<R> excelClass) {
        this.excelClass = excelClass;
    }

    public void setHeadNames(List<String> headNames) {
        this.headNames = headNames;
    }

    public void setExcelFields(List<Field> excelFields) {
        this.excelFields = excelFields;
    }

    public void setReadListenersCache(Map<Class<? extends ExcelReadListener>, List<ExcelReadListener>> readListenersCache) {
        this.readListenersCache = readListenersCache;
    }

    public void setResultReadListener(ExcelResultReadListener<R> resultReadListener) {
        this.resultReadListener = resultReadListener;
    }
}

