/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.write;

import cn.gjing.tools.excel.BigTitle;
import cn.gjing.tools.excel.Excel;
import cn.gjing.tools.excel.ExcelStyle;
import cn.gjing.tools.excel.MetaObject;
import cn.gjing.tools.excel.MetaStyle;
import cn.gjing.tools.excel.resolver.ExcelWriterResolver;
import cn.gjing.tools.excel.util.BeanUtils;
import cn.gjing.tools.excel.write.ExcelWriteXLSResolver;
import cn.gjing.tools.excel.write.ExcelWriteXLSXResolver;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExcelWriter {
    private String fileName;
    private MetaStyle metaStyle;
    private Workbook workbook;
    private HttpServletResponse response;
    private ExcelWriterResolver writerResolver;
    private List<Field> headFieldList;
    private BigTitle bigTitle;
    private boolean changed = true;
    private String defaultSheet = "sheet1";

    private ExcelWriter() {
    }

    public ExcelWriter(String fileName, Excel excel, HttpServletResponse response, List<Field> headFieldList) {
        this.fileName = fileName;
        this.response = response;
        this.headFieldList = headFieldList;
        this.initResolver(excel);
        this.initStyle(excel, this.workbook);
    }

    /*
     * Unable to fully structure code
     */
    private void initResolver(Excel excel) {
        switch (1.$SwitchMap$cn$gjing$tools$excel$Type[excel.type().ordinal()]) {
            case 1: {
                this.workbook = new HSSFWorkbook();
                try {
                    xlsResolver = new ExcelWriteXLSResolver();
                    var3_6 = null;
                    this.writerResolver = xlsResolver;
                    if (xlsResolver == null) break;
                    if (var3_6 == null) ** GOTO lbl17
                    try {
                        xlsResolver.close();
                    }
                    catch (Throwable var4_8) {
                        var3_6.addSuppressed(var4_8);
                    }
                    break;
lbl17:
                    // 1 sources

                    xlsResolver.close();
                    ** break;
                    catch (Throwable var4_9) {
                        try {
                            var3_6 = var4_9;
                            throw var4_9;
                        }
                        catch (Throwable var5_12) {
                            if (xlsResolver != null) {
                                if (var3_6 != null) {
                                    try {
                                        xlsResolver.close();
                                    }
                                    catch (Throwable var6_13) {
                                        var3_6.addSuppressed(var6_13);
                                    }
                                } else {
                                    xlsResolver.close();
                                }
                            }
                            throw var5_12;
lbl34:
                            // 1 sources

                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 2: {
                this.workbook = new SXSSFWorkbook();
                try {
                    xlsxResolver = new ExcelWriteXLSXResolver();
                    var3_7 = null;
                    this.writerResolver = xlsxResolver;
                    if (xlsxResolver == null) break;
                    if (var3_7 == null) ** GOTO lbl53
                    try {
                        xlsxResolver.close();
                    }
                    catch (Throwable var4_10) {
                        var3_7.addSuppressed(var4_10);
                    }
                    break;
lbl53:
                    // 1 sources

                    xlsxResolver.close();
                    ** break;
                    catch (Throwable var4_11) {
                        try {
                            var3_7 = var4_11;
                            throw var4_11;
                        }
                        catch (Throwable var7_14) {
                            if (xlsxResolver != null) {
                                if (var3_7 != null) {
                                    try {
                                        xlsxResolver.close();
                                    }
                                    catch (Throwable var8_15) {
                                        var3_7.addSuppressed(var8_15);
                                    }
                                } else {
                                    xlsxResolver.close();
                                }
                            }
                            throw var7_14;
lbl70:
                            // 1 sources

                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
        }
    }

    private void initStyle(Excel excel, Workbook workbook) {
        try {
            ExcelStyle excelStyle = excel.style().newInstance();
            this.metaStyle = new MetaStyle(excelStyle.setHeaderStyle(workbook.createCellStyle()), excelStyle.setBodyStyle(workbook.createCellStyle()), excelStyle.setTitleStyle(workbook.createCellStyle()));
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
    }

    public ExcelWriter write(List<?> data) {
        return this.write(data, this.defaultSheet, this.metaStyle, new HashMap<String, String[]>(16), null);
    }

    public ExcelWriter write(List<?> data, Map<String, String[]> explicitValues) {
        return this.write(data, this.defaultSheet, this.metaStyle, explicitValues, null);
    }

    public ExcelWriter write(List<?> data, String sheetName) {
        return this.write(data, sheetName, this.metaStyle, new HashMap<String, String[]>(16), null);
    }

    public ExcelWriter write(List<?> data, String sheetName, Map<String, String[]> explicitValues) {
        return this.write(data, sheetName, this.metaStyle, explicitValues, null);
    }

    public ExcelWriter write(List<?> data, Supplier<? extends ExcelStyle> style) {
        return this.write(data, this.defaultSheet, style, new HashMap<String, String[]>(16), null);
    }

    public ExcelWriter write(List<?> data, Supplier<? extends ExcelStyle> style, Map<String, String[]> explicitValues) {
        return this.write(data, this.defaultSheet, style, explicitValues, null);
    }

    public ExcelWriter write(List<?> data, String sheetName, Supplier<? extends ExcelStyle> style) {
        return this.write(data, sheetName, style, new HashMap<String, String[]>(16), null);
    }

    public ExcelWriter write(List<?> data, String sheetName, Supplier<? extends ExcelStyle> style, BigTitle bigTitle) {
        return this.write(data, sheetName, style, new HashMap<String, String[]>(16), bigTitle);
    }

    public ExcelWriter write(List<?> data, String sheetName, Supplier<? extends ExcelStyle> style, Map<String, String[]> explicitValues) {
        return this.write(data, sheetName, style, explicitValues, null);
    }

    public ExcelWriter write(List<?> data, BigTitle bigTitle) {
        return this.write(data, this.defaultSheet, this.metaStyle, new HashMap<String, String[]>(16), bigTitle);
    }

    public ExcelWriter write(List<?> data, String sheetName, BigTitle bigTitle) {
        return this.write(data, sheetName, this.metaStyle, new HashMap<String, String[]>(16), bigTitle);
    }

    public ExcelWriter write(List<?> data, Supplier<? extends ExcelStyle> style, BigTitle bigTitle) {
        return this.write(data, this.defaultSheet, style, new HashMap<String, String[]>(16), bigTitle);
    }

    public ExcelWriter write(List<?> data, Map<String, String[]> explicitValues, BigTitle bigTitle) {
        return this.write(data, this.defaultSheet, this.metaStyle, explicitValues, bigTitle);
    }

    public ExcelWriter write(List<?> data, Supplier<? extends ExcelStyle> style, Map<String, String[]> explicitValues, BigTitle bigTitle) {
        return this.write(data, this.defaultSheet, style, explicitValues, bigTitle);
    }

    public ExcelWriter write(List<?> data, String sheetName, Map<String, String[]> explicitValues, BigTitle bigTitle) {
        return this.write(data, sheetName, this.metaStyle, explicitValues, bigTitle);
    }

    public ExcelWriter write(List<?> data, String sheetName, Supplier<? extends ExcelStyle> style, Map<String, String[]> explicitValues, BigTitle bigTitle) {
        ExcelStyle excelStyle = style.get();
        MetaStyle metaStyle = new MetaStyle(excelStyle.setHeaderStyle(this.workbook.createCellStyle()), excelStyle.setBodyStyle(this.workbook.createCellStyle()), excelStyle.setTitleStyle(this.workbook.createCellStyle()));
        return this.write(data, sheetName, metaStyle, explicitValues, bigTitle);
    }

    public ExcelWriter resetResolver(Supplier<? extends ExcelWriterResolver> excelWriteResolver) {
        this.writerResolver = excelWriteResolver.get();
        return this;
    }

    public ExcelWriter resetExcelClass(Class<?> excelClass, String ... ignores) {
        Excel excel = excelClass.getAnnotation(Excel.class);
        Objects.requireNonNull(excel, "@Excel was not found on the excelClass");
        try {
            ExcelStyle excelStyle = excel.style().newInstance();
            this.metaStyle = new MetaStyle(excelStyle.setHeaderStyle(this.workbook.createCellStyle()), excelStyle.setBodyStyle(this.workbook.createCellStyle()), excelStyle.setTitleStyle(this.workbook.createCellStyle()));
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        this.headFieldList = BeanUtils.getFields(excelClass, ignores);
        this.changed = true;
        return this;
    }

    public void flush() {
        this.writerResolver.flush(this.response, this.fileName);
    }

    private ExcelWriter write(List<?> data, String sheetName, MetaStyle metaStyle, Map<String, String[]> explicitValues, BigTitle bigTitle) {
        this.writerResolver.write(data, this.workbook, sheetName, this.headFieldList, new MetaObject(bigTitle, metaStyle, explicitValues), this.changed);
        this.changed = false;
        return this;
    }
}

