/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.write;

import cn.gjing.tools.excel.MetaObject;
import cn.gjing.tools.excel.Type;
import cn.gjing.tools.excel.resolver.ExcelWriterResolver;
import cn.gjing.tools.excel.write.ExcelHelper;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

class ExcelWriteXLSXResolver
implements ExcelWriterResolver,
Closeable {
    private SXSSFWorkbook workbook;
    private OutputStream outputStream;
    private ExcelHelper excelHelper;

    ExcelWriteXLSXResolver() {
    }

    @Override
    public void write(List<?> data, Workbook workbook, String sheetName, List<Field> headFieldList, MetaObject metaObject, boolean changed) {
        this.workbook = (SXSSFWorkbook)workbook;
        SXSSFSheet sheet = this.workbook.getSheet(sheetName);
        if (sheet == null) {
            changed = true;
            sheet = this.workbook.createSheet(sheetName);
        }
        if (this.excelHelper == null) {
            this.excelHelper = new ExcelHelper((Workbook)this.workbook, Type.XLSX);
        }
        int offset = this.excelHelper.setBigTitle(headFieldList, metaObject, (Sheet)sheet);
        this.excelHelper.setVal(data, headFieldList, (Sheet)sheet, changed, offset, metaObject);
    }

    @Override
    public void flush(HttpServletResponse response, String fileName) {
        response.setContentType("application/vnd.ms-excel");
        try {
            response.setHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8") + ".xlsx");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try {
            this.outputStream = response.getOutputStream();
            this.workbook.write(this.outputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.flush();
            this.outputStream.close();
        }
        if (this.workbook != null) {
            this.workbook.close();
        }
    }
}

