/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.valid;

import cn.gjing.tools.excel.valid.ExcelValidation;
import cn.gjing.tools.excel.valid.ExplicitValid;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;

public class DefaultExplicitValidation
implements ExcelValidation {
    @Override
    public void valid(ExplicitValid explicitValid, Workbook workbook, Sheet sheet, int firstRow, int firstCol, int lastCol, int validIndex, String[] values) {
        DataValidationConstraint constraint;
        DataValidationHelper helper = sheet.getDataValidationHelper();
        if (values == null) {
            constraint = helper.createExplicitListConstraint(explicitValid.combobox());
        } else {
            Sheet explicitSheet = workbook.createSheet("explicitSheet" + validIndex);
            for (int i = 0; i < values.length; ++i) {
                explicitSheet.createRow(i).createCell(0).setCellValue(values[i]);
            }
            constraint = helper.createFormulaListConstraint(explicitSheet.getSheetName() + "!$A$1:$A$" + values.length);
            workbook.setSheetHidden(validIndex + 1, true);
        }
        CellRangeAddressList regions = new CellRangeAddressList(firstRow, explicitValid.boxLastRow() == 0 ? firstRow : explicitValid.boxLastRow() + firstRow, firstCol, lastCol);
        DataValidation dataValidation = helper.createValidation(constraint, regions);
        dataValidation.setShowErrorBox(explicitValid.showErrorBox());
        dataValidation.setShowPromptBox(explicitValid.showPromptBox());
        dataValidation.setErrorStyle(explicitValid.rank().getRank());
        dataValidation.createErrorBox(explicitValid.errorTitle(), explicitValid.errorContent());
        sheet.addValidationData(dataValidation);
    }
}

