/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.util;

import cn.gjing.tools.excel.ExcelField;
import cn.gjing.tools.excel.util.ParamUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class BeanUtils {
    public static Method findDeclaredMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) {
        try {
            return clazz.getDeclaredMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException var4) {
            return clazz.getSuperclass() != null ? BeanUtils.findDeclaredMethod(clazz.getSuperclass(), methodName, paramTypes) : null;
        }
    }

    public static void setFieldValue(Object o, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(o, value);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static Object getFieldValue(Object o, Field field) {
        try {
            field.setAccessible(true);
            return field.get(o);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static List<Field> getFields(Class<?> excelClass, String[] ignores) {
        Field[] declaredFields = excelClass.getDeclaredFields();
        List<Field> hasExcelFieldList = Arrays.stream(declaredFields).filter(e -> e.isAnnotationPresent(ExcelField.class)).filter(e -> ParamUtils.noContains(ignores, e.getName())).collect(Collectors.toList());
        Class<?> superclass = excelClass.getSuperclass();
        if (superclass != Object.class) {
            hasExcelFieldList.addAll(Arrays.stream(superclass.getDeclaredFields()).filter(e -> e.isAnnotationPresent(ExcelField.class)).filter(e -> ParamUtils.noContains(ignores, e.getName())).collect(Collectors.toList()));
        }
        return hasExcelFieldList;
    }

    public static Class<?> getInterfaceType(Class<?> source, Class<?> typeInterface, int paramIndex) {
        Type[] genericInterfaces;
        for (Type type : genericInterfaces = source.getGenericInterfaces()) {
            if (!type.getTypeName().startsWith(typeInterface.getName())) continue;
            ParameterizedType pt = (ParameterizedType)type;
            return (Class)pt.getActualTypeArguments()[paramIndex];
        }
        return null;
    }

    public static Enum<?> getEnum(Class<? extends Enum<?>> enumClass, String value) {
        Enum<?>[] enumConstants;
        for (Enum<?> constant : enumConstants = enumClass.getEnumConstants()) {
            if (!value.equals(constant.name())) continue;
            return constant;
        }
        throw new NullPointerException("No found your enum");
    }
}

