/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.read;

import cn.gjing.tools.excel.Listener;
import cn.gjing.tools.excel.read.DefaultExcelReadResolver;
import cn.gjing.tools.excel.resolver.ExcelReaderResolver;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class ExcelReader<T> {
    private Class<T> excelClass;
    private ExcelReaderResolver readerResolver;
    private List<T> data;
    private InputStream inputStream;
    private int headerIndex;
    private int endIndex;

    private ExcelReader() {
    }

    public ExcelReader(Class<T> excelClass, InputStream inputStream) {
        this.excelClass = excelClass;
        this.inputStream = inputStream;
        try (DefaultExcelReadResolver defaultExcelReadResolver = new DefaultExcelReadResolver();){
            this.readerResolver = defaultExcelReadResolver;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.data = new ArrayList<T>();
        this.init();
    }

    private void init() {
        this.headerIndex = 0;
        this.endIndex = 0;
    }

    public ExcelReader<T> read() {
        this.readerResolver.read(this.inputStream, this.excelClass, listener -> {
            this.data = listener;
        }, this.headerIndex, this.endIndex, "sheet1");
        this.init();
        return this;
    }

    public ExcelReader<T> read(String sheetName) {
        this.readerResolver.read(this.inputStream, this.excelClass, listener -> {
            this.data = listener;
        }, this.headerIndex, this.endIndex, sheetName);
        this.init();
        return this;
    }

    public ExcelReader<T> resetResolver(Supplier<? extends ExcelReaderResolver> excelReaderResolver) {
        this.readerResolver = excelReaderResolver.get();
        return this;
    }

    public ExcelReader<T> headerIndex(int index) {
        this.headerIndex = index - 1;
        return this;
    }

    public ExcelReader<T> endIndex(int index) {
        this.endIndex = index;
        return this;
    }

    public List<T> get() {
        return this.data;
    }

    public ExcelReader<T> listener(Listener<List<T>> resultListener) {
        resultListener.notify(this.data);
        return this;
    }
}

