/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.read;

import cn.gjing.tools.excel.EnumConvert;
import cn.gjing.tools.excel.Excel;
import cn.gjing.tools.excel.ExcelEnumConvert;
import cn.gjing.tools.excel.ExcelField;
import cn.gjing.tools.excel.Listener;
import cn.gjing.tools.excel.resolver.ExcelReaderResolver;
import cn.gjing.tools.excel.util.BeanUtils;
import cn.gjing.tools.excel.util.TimeUtils;
import cn.gjing.tools.excel.valid.DateValid;
import com.google.gson.Gson;
import com.monitorjbl.xlsx.StreamingReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

class DefaultExcelReadResolver
implements ExcelReaderResolver,
AutoCloseable {
    private Workbook workbook;
    private Sheet sheet;
    private Map<String, Field> hasAnnotationFieldMap = new HashMap<String, Field>();
    private List<String> headNameList = new ArrayList<String>();
    private int totalCol = 0;
    private InputStream inputStream;
    private Gson gson = new Gson();

    DefaultExcelReadResolver() {
    }

    @Override
    public void read(InputStream inputStream, Class<?> excelClass, Listener<List<Object>> listener, int headerIndex, int endIndex, String sheetName) {
        this.inputStream = inputStream;
        Excel excel = excelClass.getAnnotation(Excel.class);
        if (excel == null) {
            throw new NullPointerException("@Excel was not found on the excelClass");
        }
        if (this.hasAnnotationFieldMap.isEmpty()) {
            this.hasAnnotationFieldMap = Arrays.stream(excelClass.getDeclaredFields()).filter(f -> f.isAnnotationPresent(ExcelField.class)).collect(Collectors.toMap(field -> field.getAnnotation(ExcelField.class).value(), field -> field));
            Class<?> superclass = excelClass.getSuperclass();
            if (superclass != Object.class) {
                Map<String, Field> supperFieldMap = Arrays.stream(superclass.getDeclaredFields()).filter(f -> f.isAnnotationPresent(ExcelField.class)).collect(Collectors.toMap(field -> field.getAnnotation(ExcelField.class).value(), field -> field));
                this.hasAnnotationFieldMap.putAll(supperFieldMap);
            }
        }
        switch (excel.type()) {
            case XLS: {
                try {
                    if (this.workbook == null) {
                        this.workbook = new HSSFWorkbook(inputStream);
                        this.sheet = this.workbook.getSheet(sheetName);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.reader(excelClass, listener, headerIndex, endIndex);
                break;
            }
            case XLSX: {
                if (this.workbook == null) {
                    this.workbook = StreamingReader.builder().rowCacheSize(100).bufferSize(4096).open(inputStream);
                    this.sheet = this.workbook.getSheet(sheetName);
                }
                this.reader(excelClass, listener, headerIndex, endIndex);
                break;
            }
            default: {
                throw new NullPointerException("Doc type was not found");
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
    }

    private void reader(Class<?> excelClass, Listener<List<Object>> listener, int headerIndex, int endIndex) {
        ArrayList<Object> dataList = new ArrayList<Object>();
        Object o = null;
        for (Row row : this.sheet) {
            boolean n = true;
            if (row.getRowNum() < headerIndex) continue;
            if (row.getRowNum() == headerIndex) {
                if (!this.headNameList.isEmpty()) continue;
                for (Cell cell : row) {
                    ++this.totalCol;
                    this.headNameList.add(cell.getStringCellValue());
                }
                continue;
            }
            if (endIndex != 0 && endIndex == row.getRowNum()) break;
            try {
                o = excelClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
            block8: for (int c = 0; c < this.totalCol; ++c) {
                Field field = this.hasAnnotationFieldMap.get(this.headNameList.get(c));
                if (field == null) continue;
                ExcelField excelField = field.getAnnotation(ExcelField.class);
                Cell valueCell = row.getCell(c);
                if (valueCell != null) {
                    this.setValue(o, field, this.getValue(valueCell, field), excelField);
                    continue;
                }
                if (excelField.allowEmpty()) continue;
                switch (excelField.strategy()) {
                    case JUMP: {
                        n = false;
                        continue block8;
                    }
                    case ERROR: {
                        throw new NullPointerException(excelField.message());
                    }
                }
            }
            if (!n) continue;
            dataList.add(o);
        }
        listener.notify(dataList);
    }

    private String getValue(Cell cell, Field field) {
        Object value = "";
        switch (cell.getCellType()) {
            case _NONE: 
            case BLANK: 
            case ERROR: {
                break;
            }
            case BOOLEAN: {
                value = cell.getBooleanCellValue();
                break;
            }
            case NUMERIC: {
                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    DateValid valid = field.getAnnotation(DateValid.class);
                    value = TimeUtils.dateToString(cell.getDateCellValue(), valid == null ? "yyyy-MM-dd HH:mm:ss" : valid.pattern());
                    break;
                }
                NumberFormat numberFormat = NumberFormat.getInstance();
                numberFormat.setMaximumFractionDigits(10);
                numberFormat.setMinimumFractionDigits(0);
                numberFormat.setGroupingUsed(false);
                value = numberFormat.format(cell.getNumericCellValue());
                break;
            }
            case FORMULA: {
                value = cell.getCellFormula();
                break;
            }
            default: {
                value = cell.getStringCellValue();
            }
        }
        return value.toString();
    }

    private void setValue(Object o, Field field, String value, ExcelField excelField) {
        if (field.getType().isEnum()) {
            ExcelEnumConvert excelEnumConvert = field.getAnnotation(ExcelEnumConvert.class);
            Objects.requireNonNull(excelEnumConvert, "Enum convert cannot be null");
            Class<?> interfaceType = BeanUtils.getInterfaceType(excelEnumConvert.convert(), EnumConvert.class, 1);
            try {
                EnumConvert enumConvert = excelEnumConvert.convert().newInstance();
                this.setField(field, o, enumConvert.toEntityAttribute(this.gson.fromJson(value, interfaceType)));
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        } else {
            this.setField(field, o, this.gson.fromJson(this.gson.toJson((Object)value), field.getType()));
        }
    }

    private void setField(Field field, Object o, Object value) {
        BeanUtils.setFieldValue(o, field, value);
    }
}

