/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel;

import cn.gjing.tools.excel.Excel;
import cn.gjing.tools.excel.read.ExcelReader;
import cn.gjing.tools.excel.util.BeanUtils;
import cn.gjing.tools.excel.write.ExcelWriter;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;

public class ExcelFactory {
    public static ExcelWriter createWriter(Class<?> excelClass, HttpServletResponse response, String ... ignores) {
        return ExcelFactory.createWriter(null, excelClass, response, ignores);
    }

    public static ExcelWriter createWriter(String fileName, Class<?> excelClass, HttpServletResponse response, String ... ignores) {
        Excel excel = excelClass.getAnnotation(Excel.class);
        Objects.requireNonNull(excel, "@Excel was not found on the excelClass");
        List<Field> hasExcelFieldList = BeanUtils.getFields(excelClass, ignores);
        return new ExcelWriter(fileName == null ? excel.value() : fileName, excel, response, hasExcelFieldList);
    }

    public static <T> ExcelReader<T> createReader(InputStream inputStream, Class<T> excelClass) {
        return new ExcelReader<T>(excelClass, inputStream);
    }
}

