/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.common.cors;

import java.util.Arrays;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(value="tools.common.cors")
@EnableConfigurationProperties
public class CommonCors {
    private String[] allowedOrigins;
    private String[] allowedMethods;
    private String[] allowedHeaders;
    private Boolean allowCredentials;
    private Long maxAge;
    private String path;

    private static String[] $default$allowedOrigins() {
        return new String[]{"*"};
    }

    private static String[] $default$allowedMethods() {
        return new String[]{"GET", "DELETE", "POST", "PUT", "OPTIONS"};
    }

    private static String[] $default$allowedHeaders() {
        return new String[]{"*"};
    }

    private static Boolean $default$allowCredentials() {
        return true;
    }

    private static Long $default$maxAge() {
        return 1800L;
    }

    private static String $default$path() {
        return "/**";
    }

    public static CommonCorsBuilder builder() {
        return new CommonCorsBuilder();
    }

    public CommonCors(String[] allowedOrigins, String[] allowedMethods, String[] allowedHeaders, Boolean allowCredentials, Long maxAge, String path) {
        this.allowedOrigins = allowedOrigins;
        this.allowedMethods = allowedMethods;
        this.allowedHeaders = allowedHeaders;
        this.allowCredentials = allowCredentials;
        this.maxAge = maxAge;
        this.path = path;
    }

    public CommonCors() {
        this.allowedOrigins = CommonCors.$default$allowedOrigins();
        this.allowedMethods = CommonCors.$default$allowedMethods();
        this.allowedHeaders = CommonCors.$default$allowedHeaders();
        this.allowCredentials = CommonCors.$default$allowCredentials();
        this.maxAge = CommonCors.$default$maxAge();
        this.path = CommonCors.$default$path();
    }

    public String[] getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public String[] getAllowedMethods() {
        return this.allowedMethods;
    }

    public String[] getAllowedHeaders() {
        return this.allowedHeaders;
    }

    public Boolean getAllowCredentials() {
        return this.allowCredentials;
    }

    public Long getMaxAge() {
        return this.maxAge;
    }

    public String getPath() {
        return this.path;
    }

    public void setAllowedOrigins(String[] allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    public void setAllowedMethods(String[] allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    public void setAllowedHeaders(String[] allowedHeaders) {
        this.allowedHeaders = allowedHeaders;
    }

    public void setAllowCredentials(Boolean allowCredentials) {
        this.allowCredentials = allowCredentials;
    }

    public void setMaxAge(Long maxAge) {
        this.maxAge = maxAge;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommonCors)) {
            return false;
        }
        CommonCors other = (CommonCors)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getAllowedOrigins(), other.getAllowedOrigins())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getAllowedMethods(), other.getAllowedMethods())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getAllowedHeaders(), other.getAllowedHeaders())) {
            return false;
        }
        Boolean this$allowCredentials = this.getAllowCredentials();
        Boolean other$allowCredentials = other.getAllowCredentials();
        if (this$allowCredentials == null ? other$allowCredentials != null : !((Object)this$allowCredentials).equals(other$allowCredentials)) {
            return false;
        }
        Long this$maxAge = this.getMaxAge();
        Long other$maxAge = other.getMaxAge();
        if (this$maxAge == null ? other$maxAge != null : !((Object)this$maxAge).equals(other$maxAge)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        return !(this$path == null ? other$path != null : !this$path.equals(other$path));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommonCors;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getAllowedOrigins());
        result = result * 59 + Arrays.deepHashCode(this.getAllowedMethods());
        result = result * 59 + Arrays.deepHashCode(this.getAllowedHeaders());
        Boolean $allowCredentials = this.getAllowCredentials();
        result = result * 59 + ($allowCredentials == null ? 43 : ((Object)$allowCredentials).hashCode());
        Long $maxAge = this.getMaxAge();
        result = result * 59 + ($maxAge == null ? 43 : ((Object)$maxAge).hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        return result;
    }

    public String toString() {
        return "CommonCors(allowedOrigins=" + Arrays.deepToString(this.getAllowedOrigins()) + ", allowedMethods=" + Arrays.deepToString(this.getAllowedMethods()) + ", allowedHeaders=" + Arrays.deepToString(this.getAllowedHeaders()) + ", allowCredentials=" + this.getAllowCredentials() + ", maxAge=" + this.getMaxAge() + ", path=" + this.getPath() + ")";
    }

    public static class CommonCorsBuilder {
        private boolean allowedOrigins$set;
        private String[] allowedOrigins$value;
        private boolean allowedMethods$set;
        private String[] allowedMethods$value;
        private boolean allowedHeaders$set;
        private String[] allowedHeaders$value;
        private boolean allowCredentials$set;
        private Boolean allowCredentials$value;
        private boolean maxAge$set;
        private Long maxAge$value;
        private boolean path$set;
        private String path$value;

        CommonCorsBuilder() {
        }

        public CommonCorsBuilder allowedOrigins(String[] allowedOrigins) {
            this.allowedOrigins$value = allowedOrigins;
            this.allowedOrigins$set = true;
            return this;
        }

        public CommonCorsBuilder allowedMethods(String[] allowedMethods) {
            this.allowedMethods$value = allowedMethods;
            this.allowedMethods$set = true;
            return this;
        }

        public CommonCorsBuilder allowedHeaders(String[] allowedHeaders) {
            this.allowedHeaders$value = allowedHeaders;
            this.allowedHeaders$set = true;
            return this;
        }

        public CommonCorsBuilder allowCredentials(Boolean allowCredentials) {
            this.allowCredentials$value = allowCredentials;
            this.allowCredentials$set = true;
            return this;
        }

        public CommonCorsBuilder maxAge(Long maxAge) {
            this.maxAge$value = maxAge;
            this.maxAge$set = true;
            return this;
        }

        public CommonCorsBuilder path(String path) {
            this.path$value = path;
            this.path$set = true;
            return this;
        }

        public CommonCors build() {
            String[] allowedOrigins$value = this.allowedOrigins$value;
            if (!this.allowedOrigins$set) {
                allowedOrigins$value = CommonCors.$default$allowedOrigins();
            }
            String[] allowedMethods$value = this.allowedMethods$value;
            if (!this.allowedMethods$set) {
                allowedMethods$value = CommonCors.$default$allowedMethods();
            }
            String[] allowedHeaders$value = this.allowedHeaders$value;
            if (!this.allowedHeaders$set) {
                allowedHeaders$value = CommonCors.$default$allowedHeaders();
            }
            Boolean allowCredentials$value = this.allowCredentials$value;
            if (!this.allowCredentials$set) {
                allowCredentials$value = CommonCors.$default$allowCredentials();
            }
            Long maxAge$value = this.maxAge$value;
            if (!this.maxAge$set) {
                maxAge$value = CommonCors.$default$maxAge();
            }
            String path$value = this.path$value;
            if (!this.path$set) {
                path$value = CommonCors.$default$path();
            }
            return new CommonCors(allowedOrigins$value, allowedMethods$value, allowedHeaders$value, allowCredentials$value, maxAge$value, path$value);
        }

        public String toString() {
            return "CommonCors.CommonCorsBuilder(allowedOrigins$value=" + Arrays.deepToString(this.allowedOrigins$value) + ", allowedMethods$value=" + Arrays.deepToString(this.allowedMethods$value) + ", allowedHeaders$value=" + Arrays.deepToString(this.allowedHeaders$value) + ", allowCredentials$value=" + this.allowCredentials$value + ", maxAge$value=" + this.maxAge$value + ", path$value=" + this.path$value + ")";
        }
    }
}

