/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.util.excel.writer;

import cn.gjing.util.ParamUtil;
import cn.gjing.util.TimeUtil;
import cn.gjing.util.excel.Excel;
import cn.gjing.util.excel.ExcelField;
import cn.gjing.util.excel.validation.DateValidation;
import cn.gjing.util.excel.validation.ExplicitValidation;
import cn.gjing.util.excel.validation.NumericValidation;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExcelWriter
implements AutoCloseable {
    private Class<?> excelClass;
    private List<?> entityList;
    private HttpServletResponse response;
    private Excel excel;
    private OutputStream outputStream;
    private Workbook workbook;
    private Sheet sheet;
    private CellStyle headerStyle;
    private CellStyle valueStyle;
    private List<String> headers;
    private List<Field> hasExcelFieldList;
    private String[] ignores;

    private ExcelWriter() {
    }

    private ExcelWriter(Class<?> excelClass, List<?> entityList, String ... ignores) {
        this.excelClass = excelClass;
        this.entityList = entityList;
        this.ignores = ignores;
    }

    public static <T> ExcelWriter of(Class<T> excelClass, List<T> entityList, String ... ignores) {
        if (excelClass == null) {
            throw new NullPointerException("The parameter 'excelClass' has been used @NotNull, so it cannot be null.");
        }
        return new ExcelWriter(excelClass, entityList, ignores);
    }

    public void doWrite(HttpServletResponse response) {
        if (response == null) {
            throw new NullPointerException("The parameter 'response' has been used @NotNull, so it cannot be null.");
        }
        Excel excelAnnotation = this.excelClass.getAnnotation(Excel.class);
        if (excelAnnotation == null) {
            throw new NullPointerException("@Excel was not found on the excelClass");
        }
        this.response = response;
        this.excel = excelAnnotation;
        Field[] declaredFields = this.excelClass.getDeclaredFields();
        Field[] fields = this.excelClass.getSuperclass().getDeclaredFields();
        this.hasExcelFieldList = Arrays.stream(declaredFields).filter(e -> e.isAnnotationPresent(ExcelField.class)).filter(e -> !ParamUtil.contains(this.ignores, e.getName())).collect(Collectors.toList());
        Class<?> superclass = this.excelClass.getSuperclass();
        if (superclass != Object.class) {
            this.hasExcelFieldList.addAll(Arrays.stream(superclass.getDeclaredFields()).filter(e -> e.isAnnotationPresent(ExcelField.class)).filter(e -> !ParamUtil.contains(this.ignores, e.getName())).collect(Collectors.toList()));
        }
        this.headers = this.hasExcelFieldList.stream().map(e -> e.getAnnotation(ExcelField.class).name()).collect(Collectors.toList());
        switch (excelAnnotation.type()) {
            case XLS: {
                this.workbook = new HSSFWorkbook();
                this.sheet = this.workbook.createSheet();
                this.headerStyle = this.setHeaderStyle(this.workbook);
                this.valueStyle = this.setValueStyle(this.workbook);
                this.writeXLS();
                break;
            }
            case XLSX: {
                this.workbook = new SXSSFWorkbook();
                this.sheet = this.workbook.createSheet();
                this.headerStyle = this.setHeaderStyle(this.workbook);
                this.valueStyle = this.setValueStyle(this.workbook);
                this.writeXLSX();
                break;
            }
            default: {
                throw new NullPointerException("Doc type was not found");
            }
        }
    }

    private void writeXLS() {
        HSSFRow row;
        if (!ParamUtil.equals("", this.excel.description())) {
            row = (HSSFRow)this.sheet.createRow(this.excel.firstRow());
            HSSFCell cell = row.createCell(this.excel.firstCell());
            cell.setCellStyle(this.setDescriptionStyle(this.workbook));
            this.sheet.addMergedRegion(new CellRangeAddress(this.excel.firstRow(), this.excel.lastRow(), this.excel.firstCell(), this.excel.lastCell() == 0 ? this.headers.size() - 1 : this.excel.lastCell()));
            cell.setCellValue(this.excel.description());
            HSSFRow headerRow = (HSSFRow)this.sheet.createRow(this.excel.lastRow() + 1);
            this.setHeader((Row)headerRow);
            if (this.entityList != null) {
                int hasRow = this.excel.lastRow() + 2;
                for (int i = 0; i < this.entityList.size(); ++i) {
                    Object t = this.entityList.get(i);
                    row = (HSSFRow)this.sheet.createRow(hasRow + i);
                    this.setValue(t, (Row)row);
                }
            }
        } else {
            row = (HSSFRow)this.sheet.createRow(0);
            this.setHeader((Row)row);
            if (this.entityList != null) {
                for (int i = 0; i < this.entityList.size(); ++i) {
                    Object t = this.entityList.get(i);
                    row = (HSSFRow)this.sheet.createRow(i + 1);
                    this.setValue(t, (Row)row);
                }
            }
        }
        this.response.setContentType("application/vnd.ms-excel");
        this.response.setHeader("Content-disposition", "attachment;filename=" + new String(this.excel.name().getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1) + ".xls");
        try {
            this.outputStream = this.response.getOutputStream();
            this.workbook.write(this.outputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeXLSX() {
        if (!ParamUtil.equals("", this.excel.description())) {
            SXSSFRow row = (SXSSFRow)this.sheet.createRow(this.excel.firstRow());
            SXSSFCell cell = row.createCell(this.excel.firstCell());
            cell.setCellStyle(this.setDescriptionStyle(this.workbook));
            this.sheet.addMergedRegion(new CellRangeAddress(this.excel.firstRow(), this.excel.lastRow(), this.excel.firstCell(), this.excel.lastCell() == 0 ? this.headers.size() - 1 : this.excel.lastCell()));
            cell.setCellValue(this.excel.description());
            this.setHeader(this.sheet.createRow(this.excel.lastRow() + 1));
            if (this.entityList != null) {
                int hasRow = this.excel.lastRow() + 2;
                for (int i = 0; i < this.entityList.size(); ++i) {
                    Object t = this.entityList.get(i);
                    row = (SXSSFRow)this.sheet.createRow(hasRow + i);
                    this.setValue(t, (Row)row);
                }
            }
        } else {
            this.setHeader(this.sheet.createRow(0));
            if (this.entityList != null) {
                for (int i = 0; i < this.entityList.size(); ++i) {
                    Object t = this.entityList.get(i);
                    Row row = this.sheet.createRow(i + 1);
                    this.setValue(t, row);
                }
            }
        }
        this.response.setContentType("application/vnd.ms-excel");
        this.response.setHeader("Content-disposition", "attachment;filename=" + new String(this.excel.name().getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1) + ".xlsx");
        try {
            this.outputStream = this.response.getOutputStream();
            this.workbook.write(this.outputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setHeader(Row row) {
        for (int i = 0; i < this.headers.size(); ++i) {
            Field field = this.hasExcelFieldList.get(i);
            this.sheet.setColumnWidth(i, field.getAnnotation(ExcelField.class).width());
            row.setHeight((short)300);
            Cell cell1 = row.createCell(i);
            cell1.setCellStyle(this.headerStyle);
            cell1.setCellValue(this.headers.get(i));
            ExplicitValidation explicitValidation = field.getAnnotation(ExplicitValidation.class);
            DateValidation dateValidation = field.getAnnotation(DateValidation.class);
            NumericValidation numericValidation = field.getAnnotation(NumericValidation.class);
            if (explicitValidation != null) {
                this.setExplicitValidation(explicitValidation, i, row.getRowNum() + 1);
            }
            if (dateValidation != null) {
                this.setDateValidation(dateValidation, i, row.getRowNum() + 1);
            }
            if (numericValidation == null) continue;
            this.setNumericValidation(numericValidation, i, row.getRowNum() + 1);
        }
    }

    private void setValue(Object t, Row row) {
        for (int i = 0; i < this.hasExcelFieldList.size(); ++i) {
            Cell cell = row.createCell(i);
            cell.setCellStyle(this.valueStyle);
            Field field = this.hasExcelFieldList.get(i);
            ExcelField excelField = field.getAnnotation(ExcelField.class);
            field.setAccessible(true);
            Object value = null;
            try {
                value = field.get(t);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            if (value == null) {
                cell.setCellValue("");
                continue;
            }
            if (ParamUtil.equals("", excelField.pattern())) {
                if (field.getType().isEnum()) {
                    try {
                        Method method = field.getType().getDeclaredMethod("from", field.getType());
                        Object data = field.get(t);
                        cell.setCellValue(method.invoke(data, data).toString());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                cell.setCellValue(value.toString());
                continue;
            }
            cell.setCellValue(TimeUtil.dateToString((Date)value, excelField.pattern()));
        }
    }

    private void setExplicitValidation(ExplicitValidation explicitValidation, int cellNum, int firstRow) {
        DataValidationHelper helper = this.sheet.getDataValidationHelper();
        DataValidationConstraint dvConstraint = helper.createExplicitListConstraint(explicitValidation.combobox());
        CellRangeAddressList regions = new CellRangeAddressList(firstRow, explicitValidation.boxLastRow() == 0 ? firstRow : explicitValidation.boxLastRow(), cellNum, cellNum);
        DataValidation dataValidation = helper.createValidation(dvConstraint, regions);
        dataValidation.setShowErrorBox(explicitValidation.showErrorBox());
        dataValidation.setShowPromptBox(explicitValidation.showPromptBox());
        dataValidation.setErrorStyle(explicitValidation.rank().getRank());
        dataValidation.createErrorBox(explicitValidation.errorTitle(), explicitValidation.errorContent());
        this.sheet.addValidationData(dataValidation);
    }

    private void setNumericValidation(NumericValidation numericValidation, int cellNum, int firstRow) {
        DataValidationHelper helper = this.sheet.getDataValidationHelper();
        DataValidationConstraint numericConstraint = helper.createNumericConstraint(numericValidation.validationType().getType(), numericValidation.operatorType().getType(), numericValidation.expr1(), numericValidation.expr2().equals("") ? null : numericValidation.expr2());
        CellRangeAddressList regions = new CellRangeAddressList(firstRow, numericValidation.boxLastRow() == 0 ? firstRow : numericValidation.boxLastRow(), cellNum, cellNum);
        DataValidation dataValidation = helper.createValidation(numericConstraint, regions);
        dataValidation.setShowErrorBox(numericValidation.showErrorBox());
        dataValidation.setShowPromptBox(numericValidation.showPromptBox());
        dataValidation.setEmptyCellAllowed(numericValidation.allowEmpty());
        dataValidation.setErrorStyle(numericValidation.rank().getRank());
        dataValidation.createErrorBox(numericValidation.errorTitle(), numericValidation.errorContent());
        dataValidation.createErrorBox(numericValidation.errorTitle(), numericValidation.errorContent());
        this.sheet.addValidationData(dataValidation);
    }

    private void setDateValidation(DateValidation validation, int cellNum, int firstRow) {
        DataValidationHelper helper = this.sheet.getDataValidationHelper();
        DataValidationConstraint dvConstraint = helper.createDateConstraint(validation.operatorType().getType(), validation.expr1(), validation.expr2(), validation.pattern());
        CellRangeAddressList regions = new CellRangeAddressList(firstRow, validation.boxLastRow() == 0 ? firstRow : validation.boxLastRow(), cellNum, cellNum);
        DataValidation dataValidation = helper.createValidation(dvConstraint, regions);
        dataValidation.setShowErrorBox(validation.showErrorBox());
        dataValidation.setShowPromptBox(validation.showPromptBox());
        dataValidation.setErrorStyle(validation.rank().getRank());
        dataValidation.createErrorBox(validation.errorTitle(), validation.errorContent());
        dataValidation.setEmptyCellAllowed(validation.allowEmpty());
        this.sheet.addValidationData(dataValidation);
    }

    private CellStyle setHeaderStyle(Workbook workbook) {
        CellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(this.excel.headerColor().getIndex());
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setWrapText(this.excel.autoWrap());
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        return style;
    }

    private CellStyle setValueStyle(Workbook workbook) {
        CellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(this.excel.valueColor().getIndex());
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setWrapText(this.excel.autoWrap());
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        return style;
    }

    private CellStyle setDescriptionStyle(Workbook workbook) {
        CellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(this.excel.descriptionColor().getIndex());
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setWrapText(this.excel.autoWrap());
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        return style;
    }

    @Override
    public void close() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.flush();
            this.outputStream.close();
        }
        if (this.workbook != null) {
            this.workbook.close();
        }
    }
}

