/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.util.excel.writer;

import cn.gjing.util.ParamUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;

@Deprecated
public class ExcelWrite2
implements Closeable {
    private List<Object[]> data;
    private String[] headers;
    private String fileName;
    private String description;
    private CellRangeAddress cellAddresses;
    private OutputStream outputStream;
    private HSSFWorkbook workbook;

    private ExcelWrite2() {
    }

    private ExcelWrite2(List<Object[]> data, String[] headers, String fileName, String description, CellRangeAddress cellAddresses) {
        this.data = data;
        this.headers = headers;
        this.fileName = fileName;
        this.description = description;
        this.cellAddresses = cellAddresses;
    }

    public static ExcelWrite2 of(List<Object[]> data, String[] headers, String fileName, String description, CellRangeAddress cellAddresses) {
        if (headers == null) {
            throw new NullPointerException("The parameter 'headers' has been used @NotNull, so it cannot be null.");
        }
        if (fileName == null) {
            throw new NullPointerException("The parameter 'fileName' has been used @NotNull, so it cannot be null.");
        }
        if (description == null) {
            throw new NullPointerException("The parameter 'description' has been used @NotNull, so it cannot be null.");
        }
        if (cellAddresses == null) {
            throw new NullPointerException("The parameter 'cellAddresses' has been used @NotNull, so it cannot be null.");
        }
        return new ExcelWrite2(data, headers, fileName, description, cellAddresses);
    }

    public static ExcelWrite2 of(List<Object[]> data, String[] headers, String fileName) {
        if (headers == null) {
            throw new NullPointerException("The parameter 'headers' has been used @NotNull, so it cannot be null.");
        }
        if (fileName == null) {
            throw new NullPointerException("The parameter 'fileName' has been used @NotNull, so it cannot be null.");
        }
        return new ExcelWrite2(data, headers, fileName, null, null);
    }

    public void doWrite(HttpServletResponse response) {
        HSSFWorkbook wb = this.write();
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment;filename=" + new String(this.fileName.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1) + ".xls");
        try {
            this.outputStream = response.getOutputStream();
            wb.write(this.outputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private HSSFWorkbook write() {
        HSSFWorkbook wb;
        block6: {
            int i;
            HSSFCellStyle valueStyle;
            HSSFCellStyle headerStyle;
            HSSFSheet sheet;
            block5: {
                this.workbook = wb = new HSSFWorkbook();
                sheet = wb.createSheet(this.fileName);
                headerStyle = this.setHeaderStyle(wb);
                valueStyle = this.setValueStyle(wb);
                if (!ParamUtil.isNotEmpty(this.description)) break block5;
                HSSFRow row = sheet.createRow(0);
                HSSFCell cell = row.createCell(0);
                cell.setCellStyle(this.setOutlineStyle(wb));
                sheet.addMergedRegion(this.cellAddresses);
                cell.setCellValue(this.description);
                HSSFRow row1 = sheet.createRow(this.cellAddresses.getLastRow() + 1);
                for (int i2 = 0; i2 < this.headers.length; ++i2) {
                    row1.setHeight((short)300);
                    sheet.setColumnWidth(0, 5120);
                    HSSFCell cell1 = row1.createCell(i2);
                    cell1.setCellStyle(headerStyle);
                    cell1.setCellValue(this.headers[i2]);
                }
                if (this.data == null) break block6;
                int alreadyRow = this.cellAddresses.getLastRow() + 2;
                for (int i3 = 0; i3 < this.data.size(); ++i3) {
                    Object[] obj = this.data.get(i3);
                    row = sheet.createRow(i3 + alreadyRow);
                    this.addCellValue(valueStyle, obj, row);
                }
                break block6;
            }
            HSSFRow row = sheet.createRow(0);
            for (i = 0; i < this.headers.length; ++i) {
                row.setHeight((short)300);
                sheet.setColumnWidth(0, 5120);
                HSSFCell cell = row.createCell(i);
                cell.setCellStyle(headerStyle);
                cell.setCellValue(this.headers[i]);
            }
            if (this.data != null) {
                for (i = 0; i < this.data.size(); ++i) {
                    Object[] obj = this.data.get(i);
                    HSSFRow row1 = sheet.createRow(i + 1);
                    this.addCellValue(valueStyle, obj, row1);
                }
            }
        }
        return wb;
    }

    private void addCellValue(HSSFCellStyle style, Object[] obj, HSSFRow row) {
        for (int j = 0; j < obj.length; ++j) {
            HSSFCell cell = row.createCell(j);
            cell.setCellStyle(style);
            if (ParamUtil.isNotEmpty(obj[j])) {
                cell.setCellValue(obj[j].toString());
                continue;
            }
            cell.setCellValue("");
        }
    }

    private HSSFCellStyle setHeaderStyle(HSSFWorkbook hssfWorkbook) {
        HSSFCellStyle style = hssfWorkbook.createCellStyle();
        HSSFDataFormat format = hssfWorkbook.createDataFormat();
        style.setFillForegroundColor(IndexedColors.SKY_BLUE.getIndex());
        style.setDataFormat(format.getFormat("@"));
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        return style;
    }

    private HSSFCellStyle setValueStyle(HSSFWorkbook hssfWorkbook) {
        HSSFCellStyle style = hssfWorkbook.createCellStyle();
        style.setFillForegroundColor(IndexedColors.WHITE.getIndex());
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setWrapText(true);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        return style;
    }

    private HSSFCellStyle setOutlineStyle(HSSFWorkbook hssfWorkbook) {
        HSSFCellStyle style = hssfWorkbook.createCellStyle();
        style.setFillForegroundColor(IndexedColors.YELLOW.getIndex());
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        return style;
    }

    @Override
    public void close() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.flush();
            this.outputStream.close();
        }
        if (this.workbook != null) {
            this.workbook.close();
        }
    }
}

