/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.util.excel.reader;

import cn.gjing.util.BeanUtil;
import cn.gjing.util.ParamUtil;
import cn.gjing.util.TimeUtil;
import cn.gjing.util.excel.Excel;
import cn.gjing.util.excel.ExcelField;
import cn.gjing.util.excel.reader.Generate;
import cn.gjing.util.id.IdUtil;
import com.monitorjbl.xlsx.StreamingReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelReader<T>
implements AutoCloseable {
    private IdUtil idUtil;
    private Class<T> excelClass;
    private Excel excel;
    private Workbook workbook;
    private InputStream inputStream;
    private Sheet sheet;
    private Map<String, Field> hasAnnotationFieldMap = new HashMap<String, Field>(16);
    private List<T> data = new ArrayList<T>();

    private ExcelReader() {
    }

    private ExcelReader(Class<T> excelClass, InputStream inputStream, IdUtil idUtil) {
        this.excelClass = excelClass;
        this.inputStream = inputStream;
        this.idUtil = idUtil;
    }

    public static <T> ExcelReader<T> of(Class<T> excelClass, InputStream inputStream) {
        return new ExcelReader<T>(excelClass, inputStream, null);
    }

    public static <T> ExcelReader<T> of(Class<T> excelClass, InputStream inputStream, IdUtil idUtil) {
        return new ExcelReader<T>(excelClass, inputStream, idUtil);
    }

    public List<T> doRead() {
        Excel excel = this.excelClass.getAnnotation(Excel.class);
        if (excel == null) {
            throw new NullPointerException("@Excel was not found on the excelClass");
        }
        this.excel = excel;
        this.hasAnnotationFieldMap = Arrays.stream(this.excelClass.getDeclaredFields()).filter(f -> f.isAnnotationPresent(ExcelField.class)).collect(Collectors.toMap(field -> field.getAnnotation(ExcelField.class).name(), field -> field));
        Class<T> superclass = this.excelClass.getSuperclass();
        if (superclass != Object.class) {
            Map<String, Field> supperFieldMap = Arrays.stream(superclass.getDeclaredFields()).filter(f -> f.isAnnotationPresent(ExcelField.class)).collect(Collectors.toMap(field -> field.getAnnotation(ExcelField.class).name(), field -> field));
            this.hasAnnotationFieldMap.putAll(supperFieldMap);
        }
        switch (excel.type()) {
            case XLS: {
                try {
                    this.workbook = new HSSFWorkbook(this.inputStream);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.sheet = this.workbook.getSheetAt(0);
                this.reader();
                return this.data;
            }
            case XLSX: {
                this.workbook = StreamingReader.builder().rowCacheSize(100).bufferSize(4096).open(this.inputStream);
                this.sheet = this.workbook.getSheetAt(0);
                this.reader();
                return this.data;
            }
        }
        throw new NullPointerException("Doc type was not found");
    }

    private void reader() {
        ArrayList<String> headNameList = new ArrayList<String>();
        int rowIndex = ParamUtil.equals("", this.excel.description()) ? 1 : this.excel.lastRow() + 2;
        int headerIndex = rowIndex - 1;
        int totalCell = 0;
        Object o = null;
        for (Row row : this.sheet) {
            if (row.getRowNum() < rowIndex) {
                if (row.getRowNum() != headerIndex) continue;
                for (Cell cell : row) {
                    ++totalCell;
                    headNameList.add(cell.getStringCellValue());
                }
                continue;
            }
            try {
                o = this.excelClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
            for (int c = 0; c < totalCell; ++c) {
                Field field = this.hasAnnotationFieldMap.get(headNameList.get(c));
                if (field == null) continue;
                ExcelField excelField = field.getAnnotation(ExcelField.class);
                if (excelField.strategy() != Generate.NONE) {
                    switch (excelField.strategy()) {
                        case UUID: {
                            this.setField(field, o, this.idUtil.uuid());
                            break;
                        }
                        case SNOW_ID: {
                            this.setField(field, o, this.idUtil.snowId());
                            break;
                        }
                    }
                    continue;
                }
                Cell cell = row.getCell(c);
                if (cell == null) continue;
                this.setValue(o, field, this.getValue(cell), excelField);
            }
            this.data.add(o);
        }
    }

    private String getValue(Cell cell) {
        Object value = "";
        switch (cell.getCellType()) {
            case _NONE: 
            case BLANK: 
            case ERROR: {
                break;
            }
            case BOOLEAN: {
                value = cell.getBooleanCellValue();
                break;
            }
            case NUMERIC: {
                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    value = TimeUtil.dateToString(cell.getDateCellValue());
                    break;
                }
                value = cell.getNumericCellValue();
                break;
            }
            case FORMULA: {
                value = cell.getCellFormula();
                break;
            }
            default: {
                value = cell.getStringCellValue();
            }
        }
        return value.toString();
    }

    private void setValue(Object o, Field field, String value, ExcelField excelField) {
        if (field.getType() == String.class) {
            this.setField(field, o, value);
            return;
        }
        if (field.getType() == Integer.TYPE || field.getType() == Integer.class) {
            this.setField(field, o, Double.valueOf(value).intValue());
            return;
        }
        if (field.getType() == Long.TYPE || field.getType() == Long.class) {
            this.setField(field, o, Double.valueOf(value).longValue());
            return;
        }
        if (field.getType() == Boolean.TYPE || field.getType() == Boolean.class) {
            this.setField(field, o, Boolean.parseBoolean(value));
            return;
        }
        if (field.getType() == Date.class) {
            this.setField(field, o, ParamUtil.equals("", excelField.pattern()) ? TimeUtil.stringToDate(value) : TimeUtil.stringToDate(value, excelField.pattern()));
            return;
        }
        if (field.getType().isEnum()) {
            Class<?> type = field.getType();
            Object invoke = null;
            try {
                Method to = BeanUtil.findDeclaredMethod(field.getType(), "to", Object.class);
                assert (to != null);
                invoke = to.invoke(Enum.valueOf(type, ((Enum[])type.getEnumConstants())[0].toString()), value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.setField(field, o, invoke);
            return;
        }
        if (field.getType() == Double.TYPE || field.getType() == Double.class) {
            this.setField(field, o, Double.parseDouble(value));
            return;
        }
        if (field.getType() == Float.TYPE || field.getType() == Float.class) {
            this.setField(field, o, Float.valueOf(Float.parseFloat(value)));
            return;
        }
        if (field.getType() == Byte.TYPE || field.getType() == Byte.class) {
            this.setField(field, o, Byte.parseByte(value));
        }
    }

    private void setField(Field field, Object o, Object value) {
        BeanUtil.setFieldValue(o, field, value);
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
    }
}

