/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletResponse;

public class FileUtil {
    private FileUtil() {
    }

    public static FileUtil of() {
        return new FileUtil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadByUrl(String fileUrl, String fileName, String savePath) {
        InputStream inputStream = null;
        FileOutputStream fos = null;
        BufferedOutputStream br = null;
        try {
            URL url = new URL(fileUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(5000);
            conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            inputStream = conn.getInputStream();
            byte[] data = this.readInputStream(inputStream);
            File mkdirPath = new File(savePath);
            if (!mkdirPath.exists()) {
                boolean bl = mkdirPath.mkdirs();
            }
            File file = new File(mkdirPath + File.separator + fileName);
            fos = new FileOutputStream(file);
            br = new BufferedOutputStream(fos);
            br.write(data);
            this.close(fos, br, null, null, inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.close(fos, br, null, null, inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadByStream(HttpServletResponse response, File file) {
        BufferedInputStream is = null;
        OutputStream os = null;
        try {
            int len;
            is = new BufferedInputStream(new FileInputStream(file));
            os = new BufferedOutputStream((OutputStream)response.getOutputStream());
            response.setCharacterEncoding("utf-8");
            response.setContentType("multipart/form-data");
            response.setHeader("Content-Disposition", "attachment;fileName=" + URLEncoder.encode(file.getName(), "UTF-8"));
            response.setContentLength((int)file.length());
            byte[] b = new byte[1024];
            while (-1 != (len = ((InputStream)is).read(b))) {
                os.write(b, 0, len);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (os != null) {
                    os.flush();
                    os.close();
                }
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(File file) {
        byte[] buffer = null;
        FileInputStream fis = null;
        ByteArrayOutputStream bos = null;
        try {
            int n;
            fis = new FileInputStream(file);
            bos = new ByteArrayOutputStream(1024);
            byte[] b = new byte[1000];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            buffer = bos.toByteArray();
            this.close(null, null, fis, bos, null);
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
                this.close(null, null, fis, bos, null);
            }
            catch (Throwable throwable) {
                this.close(null, null, fis, bos, null);
                throw throwable;
            }
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeFile(byte[] bytes, File file) {
        FileOutputStream fileOutputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            bufferedOutputStream.write(bytes);
            boolean bl = true;
            this.close(fileOutputStream, bufferedOutputStream, null, null, null);
            return bl;
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
                boolean bl = false;
                this.close(fileOutputStream, bufferedOutputStream, null, null, null);
                return bl;
            }
            catch (Throwable throwable) {
                this.close(fileOutputStream, bufferedOutputStream, null, null, null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readInputStream(InputStream inputStream) {
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            int len;
            while ((len = inputStream.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return bos.toByteArray();
    }

    public String getExtension(String fileName) {
        int pos = fileName.lastIndexOf(".");
        return fileName.substring(pos);
    }

    private void close(FileOutputStream fileOutputStream, BufferedOutputStream bufferedOutputStream, FileInputStream fileInputStream, ByteArrayOutputStream byteArrayOutputStream, InputStream inputStream) {
        try {
            if (bufferedOutputStream != null) {
                bufferedOutputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

