/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.util;

import cn.gjing.exception.CastException;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component
public class BeanUtil {
    public static void copyProperties(Object source, Object target, String ... ignores) {
        BeanUtils.copyProperties((Object)source, (Object)target, (String[])ignores);
    }

    public static <T> T copyProperties(Object source, Class<T> target, String ... ignores) {
        T t = null;
        try {
            t = target.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        assert (t != null);
        if (ignores == null) {
            BeanUtils.copyProperties((Object)source, t);
            return t;
        }
        BeanUtils.copyProperties((Object)source, t, (String[])ignores);
        return t;
    }

    public static <T> T toBean(Map<String, ?> map, Class<T> bean) {
        try {
            PropertyDescriptor[] pro;
            T object = bean.newInstance();
            BeanInfo beaninfo = Introspector.getBeanInfo(bean, Object.class);
            for (PropertyDescriptor property : pro = beaninfo.getPropertyDescriptors()) {
                String name = property.getName();
                Object value = map.get(name);
                Method set = property.getWriteMethod();
                set.invoke(object, value);
            }
            return object;
        }
        catch (Exception e) {
            throw new CastException(e.getMessage());
        }
    }

    public static Map<String, Object> toMap(Object bean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            PropertyDescriptor[] pro;
            BeanInfo beaninfo = Introspector.getBeanInfo(bean.getClass(), Object.class);
            for (PropertyDescriptor property : pro = beaninfo.getPropertyDescriptors()) {
                String key = property.getName();
                Method get = property.getReadMethod();
                Object value = get.invoke(bean, new Object[0]);
                map.put(key, value);
            }
            return map;
        }
        catch (Exception e) {
            throw new CastException(e.getMessage());
        }
    }

    public static Method findMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) {
        try {
            return clazz.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException var4) {
            return BeanUtil.findDeclaredMethod(clazz, methodName, paramTypes);
        }
    }

    public static Method findDeclaredMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) {
        try {
            return clazz.getDeclaredMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException var4) {
            return clazz.getSuperclass() != null ? BeanUtil.findDeclaredMethod(clazz.getSuperclass(), methodName, paramTypes) : null;
        }
    }

    public static void setFieldValue(Object o, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(o, value);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static Object getFieldValue(Object o, Field field) {
        try {
            field.setAccessible(true);
            return field.get(o);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }
}

