/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import javax.imageio.ImageIO;

public class AuthCodeUtil {
    private int width = 160;
    private int height = 40;
    private int codeCount = 4;
    private int lineCount = 50;
    private String code = null;
    private char[] codeSequence = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private BufferedImage bufferedImage;

    public AuthCodeUtil() {
        this.createCodeImage();
    }

    public AuthCodeUtil(int width, int height) {
        this.width = width;
        this.height = height;
        this.createCodeImage();
    }

    public AuthCodeUtil(int width, int height, int codeCount, int lineCount) {
        this(width, height);
        this.codeCount = codeCount;
        this.lineCount = lineCount;
        this.createCodeImage();
    }

    public AuthCodeUtil writeToLocal(String localPath) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(localPath);
        AuthCodeUtil write = this.write(outputStream);
        outputStream.flush();
        ((OutputStream)outputStream).close();
        return write;
    }

    public AuthCodeUtil write(OutputStream outputStream) throws IOException {
        ImageIO.write((RenderedImage)this.bufferedImage, "png", outputStream);
        return this;
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    public String getCode() {
        return this.code;
    }

    private void createCodeImage() {
        int blue;
        int green;
        int red;
        int x = this.width / (this.codeCount + 2);
        int fontHeight = this.height - 2;
        int codeY = this.height - 4;
        this.bufferedImage = new BufferedImage(this.width, this.height, 4);
        Graphics2D graphics2D = this.bufferedImage.createGraphics();
        Random random = new Random();
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, this.width, this.height);
        Font font = new Font("Fixedays", 0, fontHeight);
        graphics2D.setFont(font);
        for (int i = 0; i < this.lineCount; ++i) {
            int x1 = random.nextInt(this.width);
            int y1 = random.nextInt(this.height);
            int x2 = x1 + random.nextInt(this.width >> 2);
            int y2 = y1 + random.nextInt(this.height >> 2);
            red = random.nextInt(255);
            green = random.nextInt(255);
            blue = random.nextInt(255);
            graphics2D.setColor(new Color(red, green, blue));
            graphics2D.drawLine(x1, y1, x2, y2);
        }
        StringBuilder randomCode = new StringBuilder(this.codeCount);
        for (int i = 0; i < this.codeCount; ++i) {
            String strRand = String.valueOf(this.codeSequence[random.nextInt(this.codeSequence.length)]);
            red = random.nextInt(255);
            green = random.nextInt(255);
            blue = random.nextInt(255);
            graphics2D.setColor(new Color(red, green, blue));
            graphics2D.drawString(strRand, (i + 1) * x, codeY);
            randomCode.append(strRand);
        }
        this.code = randomCode.toString();
    }
}

