/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.result;

import cn.gjing.enums.HttpStatus;
import java.io.Serializable;

public class ResultVO<T>
implements Serializable {
    private int code;
    private String message;
    private T data;

    public static <T> ResultVO success(int code, String message, T data) {
        return ResultVO.builder().code(code).message(message).data(data).build();
    }

    public static <T> ResultVO success(T data) {
        return ResultVO.builder().code(HttpStatus.OK.getCode()).message(HttpStatus.OK.getMsg()).data(data).build();
    }

    public static ResultVO success() {
        return ResultVO.builder().code(HttpStatus.OK.getCode()).message(HttpStatus.OK.getMsg()).build();
    }

    public static ResultVO error(int code, String message) {
        return ResultVO.builder().code(code).message(message).build();
    }

    public static ResultVO error() {
        return ResultVO.builder().code(HttpStatus.BAD_REQUEST.getCode()).message(HttpStatus.BAD_REQUEST.getMsg()).build();
    }

    public static ResultVO error(String message) {
        return ResultVO.builder().code(HttpStatus.BAD_REQUEST.getCode()).message(message).build();
    }

    public static <T> ResultVOBuilder<T> builder() {
        return new ResultVOBuilder();
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResultVO)) {
            return false;
        }
        ResultVO other = (ResultVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResultVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "ResultVO(code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
    }

    public ResultVO() {
    }

    public ResultVO(int code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public static class ResultVOBuilder<T> {
        private int code;
        private String message;
        private T data;

        ResultVOBuilder() {
        }

        public ResultVOBuilder<T> code(int code) {
            this.code = code;
            return this;
        }

        public ResultVOBuilder<T> message(String message) {
            this.message = message;
            return this;
        }

        public ResultVOBuilder<T> data(T data) {
            this.data = data;
            return this;
        }

        public ResultVO<T> build() {
            return new ResultVO<T>(this.code, this.message, this.data);
        }

        public String toString() {
            return "ResultVO.ResultVOBuilder(code=" + this.code + ", message=" + this.message + ", data=" + this.data + ")";
        }
    }
}

