/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.result;

import java.io.Serializable;

public class PageResult<T>
implements Serializable {
    private T data;
    private int totalPages;
    private int currentPage;
    private long totalRows;
    private int pageRows;

    public static <T> PageResult of(T data, int totalPages, int currentPage) {
        return PageResult.builder().data(data).totalPages(totalPages).currentPage(currentPage).build();
    }

    public static <T> PageResult of(T data, int totalPages) {
        return PageResult.builder().data(data).totalPages(totalPages).build();
    }

    public static <T> PageResult of(T data, int totalPages, int currentPage, long totalRows) {
        return PageResult.builder().data(data).totalPages(totalPages).currentPage(currentPage).totalRows(totalRows).build();
    }

    public static <T> PageResult of(T data, int totalPages, int currentPage, long totalRows, int pageRows) {
        return PageResult.builder().data(data).totalPages(totalPages).currentPage(currentPage).totalRows(totalRows).pageRows(pageRows).build();
    }

    public static <T> PageResultBuilder<T> builder() {
        return new PageResultBuilder();
    }

    public T getData() {
        return this.data;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public long getTotalRows() {
        return this.totalRows;
    }

    public int getPageRows() {
        return this.pageRows;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setTotalPages(int totalPages) {
        this.totalPages = totalPages;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public void setTotalRows(long totalRows) {
        this.totalRows = totalRows;
    }

    public void setPageRows(int pageRows) {
        this.pageRows = pageRows;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageResult)) {
            return false;
        }
        PageResult other = (PageResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        if (this.getTotalPages() != other.getTotalPages()) {
            return false;
        }
        if (this.getCurrentPage() != other.getCurrentPage()) {
            return false;
        }
        if (this.getTotalRows() != other.getTotalRows()) {
            return false;
        }
        return this.getPageRows() == other.getPageRows();
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        result = result * 59 + this.getTotalPages();
        result = result * 59 + this.getCurrentPage();
        long $totalRows = this.getTotalRows();
        result = result * 59 + (int)($totalRows >>> 32 ^ $totalRows);
        result = result * 59 + this.getPageRows();
        return result;
    }

    public String toString() {
        return "PageResult(data=" + this.getData() + ", totalPages=" + this.getTotalPages() + ", currentPage=" + this.getCurrentPage() + ", totalRows=" + this.getTotalRows() + ", pageRows=" + this.getPageRows() + ")";
    }

    public PageResult() {
    }

    public PageResult(T data, int totalPages, int currentPage, long totalRows, int pageRows) {
        this.data = data;
        this.totalPages = totalPages;
        this.currentPage = currentPage;
        this.totalRows = totalRows;
        this.pageRows = pageRows;
    }

    public static class PageResultBuilder<T> {
        private T data;
        private int totalPages;
        private int currentPage;
        private long totalRows;
        private int pageRows;

        PageResultBuilder() {
        }

        public PageResultBuilder<T> data(T data) {
            this.data = data;
            return this;
        }

        public PageResultBuilder<T> totalPages(int totalPages) {
            this.totalPages = totalPages;
            return this;
        }

        public PageResultBuilder<T> currentPage(int currentPage) {
            this.currentPage = currentPage;
            return this;
        }

        public PageResultBuilder<T> totalRows(long totalRows) {
            this.totalRows = totalRows;
            return this;
        }

        public PageResultBuilder<T> pageRows(int pageRows) {
            this.pageRows = pageRows;
            return this;
        }

        public PageResult<T> build() {
            return new PageResult<T>(this.data, this.totalPages, this.currentPage, this.totalRows, this.pageRows);
        }

        public String toString() {
            return "PageResult.PageResultBuilder(data=" + this.data + ", totalPages=" + this.totalPages + ", currentPage=" + this.currentPage + ", totalRows=" + this.totalRows + ", pageRows=" + this.pageRows + ")";
        }
    }
}

