/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.result;

import cn.gjing.enums.HttpStatus;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ErrorResult
implements Serializable {
    private int code;
    private String message;

    public static ErrorResult failure(int code, String message) {
        return ErrorResult.builder().code(code).message(message).build();
    }

    public static ErrorResult failure() {
        return ErrorResult.builder().code(HttpStatus.BAD_REQUEST.getCode()).message(HttpStatus.BAD_REQUEST.getMsg()).build();
    }

    public static ErrorResult failure(String message) {
        return ErrorResult.builder().code(HttpStatus.BAD_REQUEST.getCode()).message(message).build();
    }

    public static Map<String, String> error(String message) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("message", message == null ? HttpStatus.INTERNAL_SERVER_ERROR.getMsg() : message);
        return map;
    }

    public static ErrorResultBuilder builder() {
        return new ErrorResultBuilder();
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErrorResult)) {
            return false;
        }
        ErrorResult other = (ErrorResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ErrorResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String toString() {
        return "ErrorResult(code=" + this.getCode() + ", message=" + this.getMessage() + ")";
    }

    public ErrorResult() {
    }

    public ErrorResult(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public static class ErrorResultBuilder {
        private int code;
        private String message;

        ErrorResultBuilder() {
        }

        public ErrorResultBuilder code(int code) {
            this.code = code;
            return this;
        }

        public ErrorResultBuilder message(String message) {
            this.message = message;
            return this;
        }

        public ErrorResult build() {
            return new ErrorResult(this.code, this.message);
        }

        public String toString() {
            return "ErrorResult.ErrorResultBuilder(code=" + this.code + ", message=" + this.message + ")";
        }
    }
}

