/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.handle;

import cn.gjing.annotation.Exclude2;
import cn.gjing.annotation.NotNull2;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
@Aspect
class NotNull2Processor {
    NotNull2Processor() {
    }

    @Pointcut(value="@annotation(cn.gjing.annotation.NotNull2)")
    public void cut() {
    }

    @Before(value="cut()")
    public void doBefore(JoinPoint joinPoint) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        assert (attributes != null);
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        NotNull2 notNull2 = method.getAnnotation(NotNull2.class);
        Parameter[] parameters = method.getParameters();
        Object[] args = joinPoint.getArgs();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            if (parameter.isAnnotationPresent(Exclude2.class) || args[i] != null) continue;
            throw new NullPointerException(notNull2.message().equals("") ? "The parameter " + parameter.getName() + " cannot be null" : notNull2.message());
        }
    }
}

