/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.cors;

import java.util.Arrays;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(value="cors")
@EnableConfigurationProperties
public class Cors {
    private String[] allowedOrigins;
    private String[] allowedMethods;
    private String[] allowedHeaders;
    private Boolean allowCredentials;
    private Long maxAge;
    private String path;

    private static String[] $default$allowedOrigins() {
        return new String[]{"*"};
    }

    private static String[] $default$allowedMethods() {
        return new String[]{"GET", "DELETE", "POST", "PUT", "OPTIONS"};
    }

    private static String[] $default$allowedHeaders() {
        return new String[]{"*"};
    }

    private static Boolean $default$allowCredentials() {
        return true;
    }

    private static Long $default$maxAge() {
        return 1800L;
    }

    private static String $default$path() {
        return "/**";
    }

    public static CorsBuilder builder() {
        return new CorsBuilder();
    }

    public Cors(String[] allowedOrigins, String[] allowedMethods, String[] allowedHeaders, Boolean allowCredentials, Long maxAge, String path) {
        this.allowedOrigins = allowedOrigins;
        this.allowedMethods = allowedMethods;
        this.allowedHeaders = allowedHeaders;
        this.allowCredentials = allowCredentials;
        this.maxAge = maxAge;
        this.path = path;
    }

    public Cors() {
        this.allowedOrigins = Cors.$default$allowedOrigins();
        this.allowedMethods = Cors.$default$allowedMethods();
        this.allowedHeaders = Cors.$default$allowedHeaders();
        this.allowCredentials = Cors.$default$allowCredentials();
        this.maxAge = Cors.$default$maxAge();
        this.path = Cors.$default$path();
    }

    public String[] getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public String[] getAllowedMethods() {
        return this.allowedMethods;
    }

    public String[] getAllowedHeaders() {
        return this.allowedHeaders;
    }

    public Boolean getAllowCredentials() {
        return this.allowCredentials;
    }

    public Long getMaxAge() {
        return this.maxAge;
    }

    public String getPath() {
        return this.path;
    }

    public void setAllowedOrigins(String[] allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    public void setAllowedMethods(String[] allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    public void setAllowedHeaders(String[] allowedHeaders) {
        this.allowedHeaders = allowedHeaders;
    }

    public void setAllowCredentials(Boolean allowCredentials) {
        this.allowCredentials = allowCredentials;
    }

    public void setMaxAge(Long maxAge) {
        this.maxAge = maxAge;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cors)) {
            return false;
        }
        Cors other = (Cors)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getAllowedOrigins(), other.getAllowedOrigins())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getAllowedMethods(), other.getAllowedMethods())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getAllowedHeaders(), other.getAllowedHeaders())) {
            return false;
        }
        Boolean this$allowCredentials = this.getAllowCredentials();
        Boolean other$allowCredentials = other.getAllowCredentials();
        if (this$allowCredentials == null ? other$allowCredentials != null : !((Object)this$allowCredentials).equals(other$allowCredentials)) {
            return false;
        }
        Long this$maxAge = this.getMaxAge();
        Long other$maxAge = other.getMaxAge();
        if (this$maxAge == null ? other$maxAge != null : !((Object)this$maxAge).equals(other$maxAge)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        return !(this$path == null ? other$path != null : !this$path.equals(other$path));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Cors;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getAllowedOrigins());
        result = result * 59 + Arrays.deepHashCode(this.getAllowedMethods());
        result = result * 59 + Arrays.deepHashCode(this.getAllowedHeaders());
        Boolean $allowCredentials = this.getAllowCredentials();
        result = result * 59 + ($allowCredentials == null ? 43 : ((Object)$allowCredentials).hashCode());
        Long $maxAge = this.getMaxAge();
        result = result * 59 + ($maxAge == null ? 43 : ((Object)$maxAge).hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        return result;
    }

    public String toString() {
        return "Cors(allowedOrigins=" + Arrays.deepToString(this.getAllowedOrigins()) + ", allowedMethods=" + Arrays.deepToString(this.getAllowedMethods()) + ", allowedHeaders=" + Arrays.deepToString(this.getAllowedHeaders()) + ", allowCredentials=" + this.getAllowCredentials() + ", maxAge=" + this.getMaxAge() + ", path=" + this.getPath() + ")";
    }

    public static class CorsBuilder {
        private boolean allowedOrigins$set;
        private String[] allowedOrigins;
        private boolean allowedMethods$set;
        private String[] allowedMethods;
        private boolean allowedHeaders$set;
        private String[] allowedHeaders;
        private boolean allowCredentials$set;
        private Boolean allowCredentials;
        private boolean maxAge$set;
        private Long maxAge;
        private boolean path$set;
        private String path;

        CorsBuilder() {
        }

        public CorsBuilder allowedOrigins(String[] allowedOrigins) {
            this.allowedOrigins = allowedOrigins;
            this.allowedOrigins$set = true;
            return this;
        }

        public CorsBuilder allowedMethods(String[] allowedMethods) {
            this.allowedMethods = allowedMethods;
            this.allowedMethods$set = true;
            return this;
        }

        public CorsBuilder allowedHeaders(String[] allowedHeaders) {
            this.allowedHeaders = allowedHeaders;
            this.allowedHeaders$set = true;
            return this;
        }

        public CorsBuilder allowCredentials(Boolean allowCredentials) {
            this.allowCredentials = allowCredentials;
            this.allowCredentials$set = true;
            return this;
        }

        public CorsBuilder maxAge(Long maxAge) {
            this.maxAge = maxAge;
            this.maxAge$set = true;
            return this;
        }

        public CorsBuilder path(String path) {
            this.path = path;
            this.path$set = true;
            return this;
        }

        public Cors build() {
            String[] allowedOrigins = this.allowedOrigins;
            if (!this.allowedOrigins$set) {
                allowedOrigins = Cors.$default$allowedOrigins();
            }
            String[] allowedMethods = this.allowedMethods;
            if (!this.allowedMethods$set) {
                allowedMethods = Cors.$default$allowedMethods();
            }
            String[] allowedHeaders = this.allowedHeaders;
            if (!this.allowedHeaders$set) {
                allowedHeaders = Cors.$default$allowedHeaders();
            }
            Boolean allowCredentials = this.allowCredentials;
            if (!this.allowCredentials$set) {
                allowCredentials = Cors.$default$allowCredentials();
            }
            Long maxAge = this.maxAge;
            if (!this.maxAge$set) {
                maxAge = Cors.$default$maxAge();
            }
            String path = this.path;
            if (!this.path$set) {
                path = Cors.$default$path();
            }
            return new Cors(allowedOrigins, allowedMethods, allowedHeaders, allowCredentials, maxAge, path);
        }

        public String toString() {
            return "Cors.CorsBuilder(allowedOrigins=" + Arrays.deepToString(this.allowedOrigins) + ", allowedMethods=" + Arrays.deepToString(this.allowedMethods) + ", allowedHeaders=" + Arrays.deepToString(this.allowedHeaders) + ", allowCredentials=" + this.allowCredentials + ", maxAge=" + this.maxAge + ", path=" + this.path + ")";
        }
    }
}

