/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class ParamUtil {
    public static <T> boolean isEmpty(T str) {
        if (str == null || "".equals(str)) {
            return true;
        }
        if (str instanceof Collection) {
            return ((Collection)str).isEmpty();
        }
        if (str instanceof Map) {
            return ((Map)str).isEmpty();
        }
        if (str.getClass().isArray()) {
            return Array.getLength(str) == 0;
        }
        return false;
    }

    public static <T> T requireNotNull(T str) {
        if (str == null) {
            throw new NullPointerException("Parameter cannot be null");
        }
        return str;
    }

    public static <T> boolean ListHasEmpty(Collection<? extends T> list) {
        return list.stream().anyMatch(ParamUtil::isEmpty);
    }

    public static boolean multiEmpty(Object ... params) {
        return Arrays.stream(params).anyMatch(ParamUtil::isEmpty);
    }

    public static <T> boolean isNotEmpty(T str) {
        return !ParamUtil.isEmpty(str);
    }

    public static boolean equals(Object t, Object u) {
        return t == u || ParamUtil.requireNotNull(t).equals(u);
    }

    public static String trim(String str) {
        return ParamUtil.isEmpty(str) ? null : str.trim();
    }

    public static List<String> trim(List<String> list) {
        List listNonNull = list.stream().filter(ParamUtil::isNotEmpty).collect(Collectors.toList());
        return listNonNull.size() <= 0 ? null : listNonNull.stream().map(ParamUtil::trim).collect(Collectors.toList());
    }

    public static String removeSymbol(String str, String symbol) {
        if (ParamUtil.isEmpty(str)) {
            return null;
        }
        str = ParamUtil.removeStartSymbol(str, symbol);
        return ParamUtil.removeEndSymbol(str, symbol);
    }

    public static String removeStartSymbol(String str, String symbol) {
        int strLen;
        if (ParamUtil.isNotEmpty(str) && (strLen = str.length()) != 0) {
            int start;
            if (ParamUtil.isEmpty(symbol)) {
                return ParamUtil.trim(str);
            }
            for (start = 0; start != strLen && symbol.indexOf(str.charAt(start)) != -1; ++start) {
            }
            return str.substring(start);
        }
        return ParamUtil.trim(str);
    }

    public static String removeEndSymbol(String str, String symbol) {
        int end;
        if (ParamUtil.isNotEmpty(str) && (end = str.length()) != 0) {
            if (ParamUtil.isEmpty(symbol)) {
                return ParamUtil.trim(str);
            }
            while (end != 0 && symbol.indexOf(str.charAt(end - 1)) != -1) {
                --end;
            }
            return str.substring(0, end);
        }
        return ParamUtil.trim(str);
    }

    public static String[] split(String str, String symbol) {
        if (ParamUtil.isEmpty(str) || symbol.length() != 1) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        while (i < str.length()) {
            if (String.valueOf(str.charAt(i)).equals(symbol)) {
                list.add(str.substring(start, i));
                start = ++i;
                continue;
            }
            ++i;
        }
        list.add(str.substring(start));
        return list.toArray(new String[0]);
    }

    public static String removeAllSymbol(String str, String symbol) {
        if (ParamUtil.isEmpty(str) || symbol.length() > 1) {
            return str;
        }
        StringBuilder builder = new StringBuilder();
        String[] strings = ParamUtil.split(str, symbol);
        if (ParamUtil.isNotEmpty(strings)) {
            for (String s : strings) {
                builder.append(s);
            }
            return builder.toString();
        }
        return null;
    }

    public static boolean contains(Object[] t, Object u) {
        if (ParamUtil.multiEmpty(t, u)) {
            return false;
        }
        for (Object o : t) {
            if (!ParamUtil.equals(o, u)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmail(String email) {
        String regex = "^([a-z0-9_\\.-]+)@([\\da-z\\.-]+)\\.([a-z\\.]{2,6})$";
        if (ParamUtil.isNotEmpty(email)) {
            return Pattern.compile(regex).matcher(email).matches();
        }
        return false;
    }

    public static boolean isMobileNumber(String phone) {
        String regex = "^1([3-8]){1}\\d{9}$";
        if (ParamUtil.isNotEmpty(phone)) {
            return Pattern.compile(regex).matcher(phone).matches();
        }
        return false;
    }

    public static boolean isTelPhone(String tel) {
        String regex = "^(0[0-9]{2,3}\\-)?([2-9][0-9]{6,7})+(\\-[0-9]{1,4})?$";
        if (ParamUtil.isNotEmpty(tel)) {
            return Pattern.compile(regex).matcher(tel).matches();
        }
        return false;
    }

    public static boolean isPostCode(String postCode) {
        String regex = "^\\d{6}$";
        if (ParamUtil.isNotEmpty(postCode)) {
            return Pattern.compile(regex).matcher(postCode).matches();
        }
        return false;
    }
}

