/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing;

import cn.gjing.exceptions.CastException;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class BeanUtil
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (BeanUtil.applicationContext == null) {
            BeanUtil.applicationContext = applicationContext;
        }
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static Object getBean(String beanName) {
        return applicationContext.getBean(beanName);
    }

    public static <T> T getBean(Class<T> beanClass) {
        return (T)applicationContext.getBean(beanClass);
    }

    public static void copyProperties(Object source, Object target) {
        BeanUtils.copyProperties((Object)source, (Object)target);
    }

    public static void copyProperties(Object source, Object target, String ... ignores) {
        BeanUtils.copyProperties((Object)source, (Object)target, (String[])ignores);
    }

    public static <T> T copyProperties(Object source, Class<T> target) {
        try {
            T t = target.newInstance();
            BeanUtil.copyProperties(source, t);
            return t;
        }
        catch (Exception e) {
            throw new CastException(e.getMessage());
        }
    }

    public static <T> T copyProperties(Object source, Class<T> target, String ... ignores) {
        T t = null;
        try {
            t = target.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        assert (t != null);
        if (ignores == null) {
            BeanUtils.copyProperties((Object)source, t);
            return t;
        }
        BeanUtils.copyProperties((Object)source, t, (String[])ignores);
        return t;
    }

    public static <T> T toBean(Map<String, ?> map, Class<T> bean) {
        try {
            PropertyDescriptor[] pro;
            T object = bean.newInstance();
            BeanInfo beaninfo = Introspector.getBeanInfo(bean, Object.class);
            for (PropertyDescriptor property : pro = beaninfo.getPropertyDescriptors()) {
                String name = property.getName();
                Object value = map.get(name);
                Method set = property.getWriteMethod();
                set.invoke(object, value);
            }
            return object;
        }
        catch (Exception e) {
            throw new CastException(e.getMessage());
        }
    }

    public static Map<String, Object> toMap(Object bean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            PropertyDescriptor[] pro;
            BeanInfo beaninfo = Introspector.getBeanInfo(bean.getClass(), Object.class);
            for (PropertyDescriptor property : pro = beaninfo.getPropertyDescriptors()) {
                String key = property.getName();
                Method get = property.getReadMethod();
                Object value = get.invoke(bean, new Object[0]);
                map.put(key, value);
            }
            return map;
        }
        catch (Exception e) {
            throw new CastException(e.getMessage());
        }
    }
}

