/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.excel;

import cn.gjing.ParamUtil;
import cn.gjing.enums.HttpStatus;
import cn.gjing.ex.ParamException;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;

class ExportExcel {
    private List<Object[]> valueList;
    private String[] headers;
    private String title;
    private String info;

    private ExportExcel(List<Object[]> valueList, String[] headers, String title, String info) {
        this.valueList = valueList;
        this.headers = headers;
        this.title = title;
        this.info = info;
    }

    static ExportExcel of(List<Object[]> valueLis, String[] headers, String title, String info) {
        return new ExportExcel(valueLis, headers, title, info);
    }

    void generateHaveExcelName(HttpServletResponse response) {
        if (ParamUtil.multiEmpty(response, this.headers, this.title)) {
            throw new ParamException(HttpStatus.PARAM_EMPTY.getMsg());
        }
        HSSFWorkbook wb = this.export();
        try {
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-disposition", "attachment;filename=" + new String(this.title.getBytes(), "ISO8859-1") + ".xlsx");
            ServletOutputStream outputStream = response.getOutputStream();
            wb.write((OutputStream)outputStream);
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private HSSFWorkbook export() {
        HSSFWorkbook wb;
        block5: {
            int i;
            HSSFCellStyle style2;
            HSSFSheet sheet;
            block4: {
                wb = new HSSFWorkbook();
                sheet = wb.createSheet(this.title);
                sheet.setDefaultColumnWidth(15);
                HSSFRow row = sheet.createRow(0);
                HSSFCellStyle style = wb.createCellStyle();
                HSSFDataFormat format = wb.createDataFormat();
                style.setFillForegroundColor(IndexedColors.SKY_BLUE.getIndex());
                style.setDataFormat(format.getFormat("@"));
                style.setAlignment(HorizontalAlignment.CENTER);
                this.setStyle(style);
                style2 = wb.createCellStyle();
                style2.setFillForegroundColor(IndexedColors.WHITE.getIndex());
                style2.setAlignment(HorizontalAlignment.CENTER);
                style2.setVerticalAlignment(VerticalAlignment.CENTER);
                this.setStyle(style2);
                for (i = 0; i < this.headers.length; ++i) {
                    HSSFCell cell = row.createCell(i);
                    cell.setCellStyle(style);
                    cell.setCellValue(this.headers[i]);
                }
                if (!ParamUtil.isNotEmpty(this.info)) break block4;
                row = sheet.createRow(1);
                HSSFCell cell = row.createCell(0);
                cell.setCellStyle(style2);
                sheet.addMergedRegion(new CellRangeAddress(1, 4, 0, this.headers.length - 1));
                cell.setCellValue(this.info);
                if (this.valueList == null) break block5;
                for (int i2 = 0; i2 < this.valueList.size(); ++i2) {
                    Object[] obj = this.valueList.get(i2);
                    HSSFRow row1 = sheet.createRow(i2 + 5);
                    row1.setHeight((short)750);
                    this.addCellValue(style2, obj, row1);
                }
                break block5;
            }
            if (this.valueList != null) {
                for (i = 0; i < this.valueList.size(); ++i) {
                    Object[] obj = this.valueList.get(i);
                    HSSFRow row1 = sheet.createRow(i + 1);
                    row1.setHeight((short)750);
                    this.addCellValue(style2, obj, row1);
                }
            }
        }
        return wb;
    }

    private void setStyle(HSSFCellStyle style) {
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
    }

    private void addCellValue(HSSFCellStyle style2, Object[] obj, HSSFRow row) {
        for (int j = 0; j < obj.length; ++j) {
            HSSFCell cell = row.createCell(j);
            cell.setCellStyle(style2);
            if (!"".equals(obj[j]) && obj[j] != null) {
                cell.setCellValue(obj[j].toString());
                continue;
            }
            cell.setCellValue("");
        }
    }
}

