/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.ex;

import cn.gjing.enums.HttpStatus;
import cn.gjing.ex.AuthException;
import cn.gjing.ex.HttpException;
import cn.gjing.ex.ParamException;
import cn.gjing.result.ErrorResult;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
@ResponseBody
public class CommonExceptionHandler {
    @ExceptionHandler(value={ParamException.class})
    public ResponseEntity paramException(ParamException e) {
        e.printStackTrace();
        return ResponseEntity.badRequest().body(ErrorResult.error(e.getMessage()));
    }

    @ExceptionHandler(value={HttpException.class})
    public ResponseEntity httpException(HttpException e) {
        e.printStackTrace();
        return ResponseEntity.badRequest().body(ErrorResult.error(e.getMessage()));
    }

    @ExceptionHandler(value={AuthException.class})
    public ResponseEntity noAuth(AuthException e) {
        e.printStackTrace();
        return ResponseEntity.status((int)HttpStatus.UNAUTHORIZED.getCode()).body(ErrorResult.error(e.getMessage()));
    }
}

