/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.result;

import cn.gjing.ParamUtil;
import cn.gjing.enums.HttpStatus;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResultVo<T> {
    private Integer code;
    private String message;
    private T data;

    public static ResultVo success(String message, Object data) {
        return ResultVo.builder().code(HttpStatus.OK.getCode()).message(message).data(data).build();
    }

    public static ResultVo success() {
        return ResultVo.builder().code(HttpStatus.OK.getCode()).message(HttpStatus.OK.getMsg()).build();
    }

    public static ResultVo success(Object data) {
        return ResultVo.builder().code(HttpStatus.OK.getCode()).message(HttpStatus.OK.getMsg()).data(data).build();
    }

    public static ResultVo error(Integer code, String message) {
        return ResultVo.builder().code(code).message(message).build();
    }

    public static ResultVo error() {
        return ResultVo.builder().code(HttpStatus.BAD_REQUEST.getCode()).message(HttpStatus.BAD_REQUEST.getMsg()).build();
    }

    public static ResultVo error(String message) {
        return ResultVo.builder().code(HttpStatus.BAD_REQUEST.getCode()).message(message).build();
    }

    @Deprecated
    public static Map<String, Object> find(List<String> keys, List<Object> val) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        for (int i = 0; i < keys.size(); ++i) {
            map.put(keys.get(i), val.get(i));
        }
        return map;
    }

    @Deprecated
    public static Map<String, Object> login(String isLogin, List<String> keys, List<Object> values) {
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        if (ParamUtil.isNotEmpty(isLogin)) {
            map.put("code", HttpStatus.OK.getCode());
            map.put("message", HttpStatus.OK.getMsg());
        } else {
            map.put("code", HttpStatus.NO_LOGIN.getCode());
            map.put("message", HttpStatus.NO_LOGIN.getMsg());
        }
        if (keys != null && values != null) {
            for (int i = 0; i < keys.size(); ++i) {
                map.put(keys.get(i), values.get(i));
            }
        }
        return map;
    }

    public static <T> ResultVoBuilder<T> builder() {
        return new ResultVoBuilder();
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResultVo)) {
            return false;
        }
        ResultVo other = (ResultVo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResultVo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "ResultVo(code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
    }

    public ResultVo() {
    }

    public ResultVo(Integer code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public static class ResultVoBuilder<T> {
        private Integer code;
        private String message;
        private T data;

        ResultVoBuilder() {
        }

        public ResultVoBuilder<T> code(Integer code) {
            this.code = code;
            return this;
        }

        public ResultVoBuilder<T> message(String message) {
            this.message = message;
            return this;
        }

        public ResultVoBuilder<T> data(T data) {
            this.data = data;
            return this;
        }

        public ResultVo<T> build() {
            return new ResultVo<T>(this.code, this.message, this.data);
        }

        public String toString() {
            return "ResultVo.ResultVoBuilder(code=" + this.code + ", message=" + this.message + ", data=" + this.data + ")";
        }
    }
}

