/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.result;

import com.google.common.collect.Maps;
import java.util.Map;
import org.springframework.http.HttpStatus;

public class ErrorResult {
    private Integer code;
    private String message;

    public static ErrorResult failure() {
        return ErrorResult.builder().code(HttpStatus.BAD_REQUEST.value()).message(HttpStatus.BAD_REQUEST.getReasonPhrase()).build();
    }

    public static ErrorResult failure(Integer code, String message) {
        return ErrorResult.builder().code(code).message(message).build();
    }

    public static ErrorResult failure(String message) {
        return ErrorResult.builder().code(HttpStatus.BAD_REQUEST.value()).message(message).build();
    }

    public static Map.Entry<String, String> error(String message) {
        return Maps.immutableEntry((Object)"message", (Object)message);
    }

    public static Map.Entry<String, String> error() {
        return Maps.immutableEntry((Object)"message", (Object)HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase());
    }

    public static ErrorResultBuilder builder() {
        return new ErrorResultBuilder();
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErrorResult)) {
            return false;
        }
        ErrorResult other = (ErrorResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ErrorResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String toString() {
        return "ErrorResult(code=" + this.getCode() + ", message=" + this.getMessage() + ")";
    }

    public ErrorResult(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public ErrorResult() {
    }

    public static class ErrorResultBuilder {
        private Integer code;
        private String message;

        ErrorResultBuilder() {
        }

        public ErrorResultBuilder code(Integer code) {
            this.code = code;
            return this;
        }

        public ErrorResultBuilder message(String message) {
            this.message = message;
            return this;
        }

        public ErrorResult build() {
            return new ErrorResult(this.code, this.message);
        }

        public String toString() {
            return "ErrorResult.ErrorResultBuilder(code=" + this.code + ", message=" + this.message + ")";
        }
    }
}

