/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.handle;

import cn.gjing.ParamUtil;
import cn.gjing.annotation.NotNull2;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
@Aspect
class NotNull2Processor {
    NotNull2Processor() {
    }

    @Pointcut(value="@annotation(cn.gjing.annotation.NotNull2)")
    public void cut() {
    }

    @Before(value="cut()")
    public void doBefore(JoinPoint joinPoint) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        assert (attributes != null);
        HttpServletRequest request = attributes.getRequest();
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        NotNull2 annotation = method.getDeclaredAnnotation(NotNull2.class);
        List<String> exclude = Arrays.asList(annotation.exclude());
        ArrayList<String> needCheckParamList = new ArrayList<String>();
        Parameter[] parameters = method.getParameters();
        if (exclude.isEmpty()) {
            for (Parameter parameter : parameters) {
                if (parameter.getType().isPrimitive() || parameter.getAnnotation(PathVariable.class) != null) continue;
                needCheckParamList.add(parameter.getName());
            }
        } else {
            for (Parameter parameter : parameters) {
                if (exclude.contains(parameter.getName()) || parameter.getType().isPrimitive() || parameter.getAnnotation(PathVariable.class) != null) continue;
                needCheckParamList.add(parameter.getName());
            }
        }
        for (String paramName : needCheckParamList) {
            if (!ParamUtil.isEmpty(request.getParameter(paramName))) continue;
            throw new NullPointerException("The parameter '" + paramName + "' has been used @NotNull2, so it cannot be null.");
        }
    }
}

