/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.excel;

import cn.gjing.ParamUtil;
import cn.gjing.enums.HttpStatus;
import cn.gjing.ex.ParamException;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;

class ExportExcel {
    ExportExcel() {
    }

    static void generateHaveExcelName(HttpServletResponse response, List<Object[]> list, String[] headers, String title, String info) {
        if (ParamUtil.multiEmpty(response, headers, title)) {
            throw new ParamException(HttpStatus.PARAM_EMPTY.getMsg());
        }
        HSSFWorkbook wb = ExportExcel.export(list, headers, title, info);
        try {
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-disposition", "attachment;filename=" + new String(title.getBytes(), "ISO8859-1") + ".xlsx");
            ServletOutputStream outputStream = response.getOutputStream();
            wb.write((OutputStream)outputStream);
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static HSSFWorkbook export(List<Object[]> list, String[] headers, String title, String info) {
        HSSFWorkbook wb;
        block5: {
            int i;
            HSSFCellStyle style2;
            HSSFSheet sheet;
            block4: {
                wb = new HSSFWorkbook();
                sheet = wb.createSheet(title);
                sheet.setDefaultColumnWidth(15);
                HSSFRow row = sheet.createRow(0);
                HSSFCellStyle style = wb.createCellStyle();
                HSSFDataFormat format = wb.createDataFormat();
                style.setFillForegroundColor(IndexedColors.SKY_BLUE.getIndex());
                style.setDataFormat(format.getFormat("@"));
                style.setAlignment(HorizontalAlignment.CENTER);
                ExportExcel.setStyle(style);
                style2 = wb.createCellStyle();
                style2.setFillForegroundColor(IndexedColors.YELLOW.getIndex());
                style2.setAlignment(HorizontalAlignment.CENTER);
                style2.setVerticalAlignment(VerticalAlignment.CENTER);
                ExportExcel.setStyle(style2);
                for (i = 0; i < headers.length; ++i) {
                    HSSFCell cell = row.createCell(i);
                    cell.setCellStyle(style);
                    cell.setCellValue(headers[i]);
                }
                if (!ParamUtil.isNotEmpty(info)) break block4;
                row = sheet.createRow(1);
                HSSFCell cell = row.createCell(0);
                cell.setCellStyle(style2);
                sheet.addMergedRegion(new CellRangeAddress(1, 4, 0, headers.length - 1));
                cell.setCellValue(info);
                if (list == null) break block5;
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    Object[] obj = list.get(i2);
                    HSSFRow row1 = sheet.createRow(i2 + 5);
                    row1.setHeight((short)750);
                    ExportExcel.addCellValue(style2, obj, row1);
                }
                break block5;
            }
            if (list != null) {
                for (i = 0; i < list.size(); ++i) {
                    Object[] obj = list.get(i);
                    HSSFRow row1 = sheet.createRow(i + 1);
                    row1.setHeight((short)750);
                    ExportExcel.addCellValue(style2, obj, row1);
                }
            }
        }
        return wb;
    }

    private static void setStyle(HSSFCellStyle style) {
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
    }

    private static void addCellValue(HSSFCellStyle style2, Object[] obj, HSSFRow row) {
        for (int j = 0; j < obj.length; ++j) {
            HSSFCell cell = row.createCell(j);
            cell.setCellStyle(style2);
            if (!"".equals(obj[j]) && obj[j] != null) {
                cell.setCellValue(obj[j].toString());
                continue;
            }
            cell.setCellValue("");
        }
    }
}

