/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;

public class TimeUtil {
    public static String getDateAsString(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(date);
    }

    public static LocalDateTime dateToLocalDateTime(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    public static LocalDate dateToLocalDate(Date date) {
        return TimeUtil.dateToLocalDateTime(date).toLocalDate();
    }

    public static Date localDateToDate(LocalDate localDate) {
        return TimeUtil.localDateTimeToDate(localDate.atStartOfDay());
    }

    public static String localDateToString(LocalDate localDate, String format) {
        return localDate.format(DateTimeFormatter.ofPattern(format));
    }

    public static String localDateTimeToString(LocalDateTime localDateTime, String format) {
        return localDateTime.format(DateTimeFormatter.ofPattern(format));
    }

    public static String localTimeToString(LocalTime localTime, String format) {
        return localTime.format(DateTimeFormatter.ofPattern(format));
    }

    public static LocalDate stringToLocalDate(String time, String format) {
        return LocalDate.parse(time, DateTimeFormatter.ofPattern(format));
    }

    public static LocalDateTime stringToLocalDateTime(String time, String format) {
        return LocalDateTime.parse(time, DateTimeFormatter.ofPattern(format));
    }

    public static Date localDateTimeToDate(LocalDateTime dateTime) {
        return Date.from(dateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static long localDateTimeToStamp(LocalDateTime localDateTime) {
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        return instant.toEpochMilli();
    }

    public static Integer getYearsByStartTime(String startTime) {
        LocalDate startDate = TimeUtil.stringToLocalDate(startTime, "yyyy-MM-dd");
        LocalDate currentDate = LocalDate.now();
        if (currentDate.isBefore(startDate)) {
            return 0;
        }
        return startDate.until(currentDate).getYears();
    }

    public static LocalDateTime stampToLocalDateTime(Long stamp) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(stamp), ZoneId.systemDefault());
    }

    public static String getDateAsString(Date date, String format) {
        SimpleDateFormat format1 = new SimpleDateFormat(format);
        return format1.format(date);
    }

    public static Date getDate(String date) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.parse(date);
    }

    public static Date getDate(String date, String format) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.parse(date);
    }

    public static Calendar stringDateToCalendar(String str) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(simpleDateFormat.parse(str));
        return calendar;
    }

    public static Date calendarToDate(Calendar calendar, String format) throws ParseException {
        return TimeUtil.getDate(TimeUtil.calendarToStringDate(calendar, format));
    }

    public static String calendarToStringDate(Calendar calendar, String format) {
        return TimeUtil.getDateAsString(calendar.getTime(), format);
    }

    public static int getAllDaysOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.getActualMaximum(5);
    }

    public static int getDays(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(5);
    }

    public static int getYears(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(1);
    }

    public static int getMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(2) + 1;
    }

    public static Date addMonth(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, n);
        return cal.getTime();
    }

    public static Date addDay(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, n);
        return cal.getTime();
    }

    public static Long stringDateToStamp(String stringDate) throws ParseException {
        return TimeUtil.getDate(stringDate).getTime();
    }

    public static String stampToStringDate(Long timeStamp) {
        long l = timeStamp;
        return TimeUtil.getDateAsString(new Date(l));
    }

    public static int dateBetween(String startDate, String endDate) throws ParseException {
        Date dateStart = TimeUtil.getDate(startDate, "yyyy-MM-dd");
        Date dateEnd = TimeUtil.getDate(endDate, "yyyy-MM-dd");
        return (int)((dateEnd.getTime() - dateStart.getTime()) / 1000L / 60L / 60L / 24L);
    }

    public static int dateBetweenIncludeToday(String startDate, String endDate) throws ParseException {
        return TimeUtil.dateBetween(startDate, endDate) + 1;
    }
}

