/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ExecutorUtil {
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int CORE_POOL_SIZE = CPU_COUNT + 1;
    private static final int MAXIMUM_POOL_SIZE = CPU_COUNT * 2 + 1;
    private static final int KEEP_ALIVE = 1;
    private static final int QUEUE = CPU_COUNT * 3;
    private static ThreadPoolExecutor threadPool = null;
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactoryBuilder().setNameFormat("gjing-%d").build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ThreadPoolExecutor getThreadPool() {
        if (threadPool != null) {
            return threadPool;
        }
        Class<ExecutorUtil> clazz = ExecutorUtil.class;
        synchronized (ExecutorUtil.class) {
            if (threadPool == null) {
                threadPool = new ThreadPoolExecutor(CORE_POOL_SIZE, MAXIMUM_POOL_SIZE, 1L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(QUEUE), THREAD_FACTORY, new ThreadPoolExecutor.AbortPolicy());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return threadPool;
        }
    }

    public static void execute(Runnable runnable) {
        ExecutorUtil.getThreadPool().execute(runnable);
    }

    public static <T> Future<T> submit(Callable<T> callable) {
        return ExecutorUtil.getThreadPool().submit(callable);
    }

    public static void cancel(Runnable runnable) {
        if (runnable != null) {
            ExecutorUtil.getThreadPool().getQueue().remove(runnable);
        }
    }
}

