/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.OSSObject;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class AliOss {
    private String endPoint;
    private String bucketName;
    private OSSClient instance;

    private AliOss(String endPoint, String accessKeyId, String accessKeySecret, String bucketName) {
        this.endPoint = endPoint;
        this.bucketName = bucketName;
        this.instance = new OSSClient(endPoint, accessKeyId, accessKeySecret);
    }

    public static AliOss of(String endPoint, String accessKeyId, String accessKeySecret, String bucketName) {
        Objects.requireNonNull(endPoint, "endPoint cannot be null");
        Objects.requireNonNull(accessKeyId, "accessKeyId cannot be null");
        Objects.requireNonNull(accessKeySecret, "accessKeySecret cannot be null");
        Objects.requireNonNull(bucketName, "bucketName cannot be null");
        return new AliOss(endPoint, accessKeyId, accessKeySecret, bucketName);
    }

    public List<String> delete(List<String> fileOssUrls) {
        List urlList = fileOssUrls.stream().map(this::getPathUrl).collect(Collectors.toList());
        try {
            return this.instance.deleteObjects(new DeleteObjectsRequest(this.bucketName).withKeys(urlList)).getDeletedObjects();
        }
        catch (RuntimeException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public String upload(MultipartFile file) {
        if (file.getSize() > 0x40000000L) {
            throw new IllegalArgumentException("Upload failed. file size cannot more than 5 gb");
        }
        this.createBucket();
        String fileName = this.uploadFile(file);
        String fileOssUrl = this.getFileUrl(fileName);
        int firstChar = fileOssUrl.indexOf("?");
        if (firstChar > 0) {
            fileOssUrl = fileOssUrl.substring(0, firstChar);
        }
        return fileOssUrl;
    }

    public boolean downloadFile(String fileOssUrl, String mkdir) {
        try {
            if (!StringUtils.isEmpty((Object)mkdir)) {
                File file = new File(mkdir);
                if (!file.exists() && !file.mkdir()) {
                    throw new IllegalStateException("Create file exception");
                }
                Predicate<String> predicate = e -> e.indexOf("/", e.length() - 1) != -1;
                String pathUrl = this.getPathUrl(fileOssUrl);
                this.instance.getObject(new GetObjectRequest(this.bucketName, pathUrl), new File(predicate.test(mkdir) ? mkdir + pathUrl : mkdir + "/" + pathUrl));
                return true;
            }
            throw new IllegalArgumentException("Mkdir cannot be null");
        }
        catch (Exception e2) {
            throw new IllegalStateException(e2.getMessage());
        }
    }

    public boolean downloadStream(String fileOssUrl, HttpServletResponse response) {
        String pathUrl = this.getPathUrl(fileOssUrl);
        OSSObject object = this.instance.getObject(this.bucketName, pathUrl);
        try {
            int len;
            InputStream is = object.getObjectContent();
            BufferedOutputStream os = new BufferedOutputStream((OutputStream)response.getOutputStream());
            response.setCharacterEncoding("utf-8");
            response.setContentType("multipart/form-data");
            response.setHeader("Content-Disposition", "attachment;fileName=" + URLEncoder.encode(this.getPathUrl(fileOssUrl), "UTF-8"));
            response.setContentLength((int)object.getObjectMetadata().getContentLength());
            byte[] b = new byte[1024];
            while (-1 != (len = is.read(b))) {
                ((OutputStream)os).write(b, 0, len);
            }
            ((OutputStream)os).flush();
            ((OutputStream)os).close();
            is.close();
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
        return true;
    }

    private void createBucket() {
        try {
            if (!this.instance.doesBucketExist(this.bucketName)) {
                this.instance.createBucket(this.bucketName);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("\u521b\u5efaBucket\u5931\u8d25,\u8bf7\u6838\u5bf9Bucket\u540d\u79f0(\u89c4\u5219\uff1a\u53ea\u80fd\u5305\u542b\u5c0f\u5199\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u77ed\u6a2a\u7ebf\uff0c\u5fc5\u987b\u4ee5\u5c0f\u5199\u5b57\u6bcd\u548c\u6570\u5b57\u5f00\u5934\u548c\u7ed3\u5c3e\uff0c\u957f\u5ea6\u57283-63\u4e4b\u95f4)");
        }
    }

    private String getContentType(String fileName) {
        String fileExtension = fileName.substring(fileName.lastIndexOf(".") + 1);
        if ("bmp".equalsIgnoreCase(fileExtension)) {
            return "image/bmp";
        }
        if ("gif".equalsIgnoreCase(fileExtension)) {
            return "image/gif";
        }
        if ("jpeg".equalsIgnoreCase(fileExtension) || "jpg".equalsIgnoreCase(fileExtension)) {
            return "image/jpeg";
        }
        if ("png".equalsIgnoreCase(fileExtension)) {
            return "image/png";
        }
        if ("html".equalsIgnoreCase(fileExtension)) {
            return "text/html";
        }
        if ("txt".equalsIgnoreCase(fileExtension)) {
            return "text/plain";
        }
        if ("vsd".equalsIgnoreCase(fileExtension)) {
            return "application/vnd.visio";
        }
        if ("ppt".equalsIgnoreCase(fileExtension) || "pptx".equalsIgnoreCase(fileExtension)) {
            return "application/vnd.ms-powerpoint";
        }
        if ("doc".equalsIgnoreCase(fileExtension) || "docx".equalsIgnoreCase(fileExtension)) {
            return "application/msword";
        }
        if ("xml".equalsIgnoreCase(fileExtension)) {
            return "text/xml";
        }
        return "text/html";
    }

    private String uploadFile(MultipartFile file) {
        String fileName = String.format("%s.%s", UUID.randomUUID().toString(), FilenameUtils.getExtension((String)file.getOriginalFilename()));
        try {
            this.instance.putObject(this.bucketName, fileName, (InputStream)new ByteArrayInputStream(file.getBytes()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fileName;
    }

    private String getFileUrl(String fileUrl) {
        if (StringUtils.isEmpty((Object)fileUrl)) {
            throw new IllegalArgumentException("The parameter fileUrl cannot be null!");
        }
        String[] split = fileUrl.split("/");
        URL url = this.instance.generatePresignedUrl(this.bucketName, split[split.length - 1], this.addDay(new Date()));
        if (url == null) {
            throw new IllegalStateException("Get oss file url error");
        }
        return url.toString();
    }

    private String getPathUrl(String fileOssUrl) {
        return fileOssUrl.substring(fileOssUrl.indexOf(this.endPoint) + this.endPoint.length() + 1);
    }

    private Date addDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, 3650);
        return cal.getTime();
    }
}

