/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.http2;

import cn.gjing.ParamUtil;
import cn.gjing.UrlUtil;
import cn.gjing.enums.HttpType;
import cn.gjing.ex.HttpException;
import cn.gjing.http2.HttpsProcess;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.springframework.http.HttpMethod;

class HttpHandle {
    HttpHandle() {
    }

    static <T> T invokeUrl(String url, Map<String, ?> params, Map<String, ?> headers, Integer connectTimeout, Integer readTimeout, HttpMethod method, Class<T> responseType) {
        if (url == null) {
            throw new NullPointerException("The parameter 'url' has been used @NotNull, so it cannot be null.");
        }
        if (connectTimeout == null) {
            throw new NullPointerException("The parameter 'connectTimeout' has been used @NotNull, so it cannot be null.");
        }
        if (readTimeout == null) {
            throw new NullPointerException("The parameter 'readTimeout' has been used @NotNull, so it cannot be null.");
        }
        if (method == null) {
            throw new NullPointerException("The parameter 'method' has been used @NotNull, so it cannot be null.");
        }
        if (responseType == null) {
            throw new NullPointerException("The parameter 'responseType' has been used @NotNull, so it cannot be null.");
        }
        String paramsStr = null;
        if (ParamUtil.isNotEmpty(params)) {
            paramsStr = UrlUtil.paramUnicodeSort(params, false, false);
            if (method != HttpMethod.POST) {
                assert (paramsStr != null);
                url = url + "?" + paramsStr;
            }
        }
        HttpURLConnection conn = null;
        BufferedWriter out = null;
        BufferedReader in = null;
        try {
            URL uUrl = new URL(url);
            if (ParamUtil.split((String)url, (String)":")[0].equals(HttpType.HTTPS.getType())) {
                SSLContext sslContext = SSLContext.getInstance("SSL");
                TrustManager[] tm = new TrustManager[]{new HttpsProcess()};
                sslContext.init(null, tm, new SecureRandom());
                SSLSocketFactory ssf = sslContext.getSocketFactory();
                HttpsURLConnection httpsConn = (HttpsURLConnection)uUrl.openConnection();
                httpsConn.setSSLSocketFactory(ssf);
                conn = httpsConn;
            } else {
                conn = (HttpURLConnection)uUrl.openConnection();
            }
            HttpHandle.setProperty(connectTimeout, readTimeout, method, conn);
            HttpHandle.addHeaders(headers, conn);
            if (paramsStr != null && method == HttpMethod.POST) {
                out = new BufferedWriter(new OutputStreamWriter(conn.getOutputStream(), Charset.defaultCharset()));
                out.write(paramsStr);
                out.flush();
            }
            StringBuilder result = null;
            in = new BufferedReader(new InputStreamReader(conn.getInputStream(), Charset.defaultCharset()));
            if (conn.getResponseCode() == 200) {
                String line;
                result = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    result.append(line);
                }
            }
            String string = result != null ? result.toString() : null;
            return (T)string;
        }
        catch (Exception e) {
            throw new HttpException(e.getMessage());
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
                if (conn != null) {
                    conn.disconnect();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void addHeaders(Map<String, ?> headers, HttpURLConnection conn) {
        if (ParamUtil.isNotEmpty(headers)) {
            Set<String> headerSet = headers.keySet();
            for (String key : headerSet) {
                conn.setRequestProperty(key, (String)headers.get(key));
            }
        }
    }

    private static void setProperty(int connectTimeout, int readTimeout, HttpMethod method, HttpURLConnection conn) throws ProtocolException {
        conn.setRequestProperty("content-type", "application/x-www-form-urlencoded");
        conn.setRequestMethod(method.toString());
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setConnectTimeout(connectTimeout);
        conn.setReadTimeout(readTimeout);
    }
}

