/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing;

import cn.gjing.HttpsClientRequestFactory;
import cn.gjing.ParamUtil;
import cn.gjing.UrlUtil;
import cn.gjing.enums.HttpType;
import cn.gjing.ex.HttpException;
import java.util.Map;
import java.util.Objects;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class HttpClient {
    private static final RestTemplate REST_TEMPLATE = new RestTemplate();
    private static final RestTemplate REST_TEMPLATE2 = new RestTemplate((ClientHttpRequestFactory)new HttpsClientRequestFactory());

    public static String post(String requestUrl, Map<String, String> params, Map<String, String> headers, String proxyIp, String proxyPort) {
        if (requestUrl == null) {
            throw new NullPointerException("The parameter 'requestUrl' has been used @NotNull, so it cannot be null.");
        }
        if (!ParamUtil.multiEmpty((Object[])new Object[]{proxyIp, proxyPort})) {
            HttpClient.setProxy(proxyIp, proxyPort);
        }
        try {
            if (ParamUtil.isNotEmpty(headers)) {
                HttpHeaders httpHeaders = new HttpHeaders();
                for (String s : headers.keySet()) {
                    httpHeaders.add(s, headers.get(s));
                }
                HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)httpHeaders);
                if (ParamUtil.isNotEmpty(params)) {
                    httpEntity = new HttpEntity(params, (MultiValueMap)httpHeaders);
                }
                return (String)HttpClient.getRestTemplate(requestUrl).exchange(requestUrl, HttpMethod.POST, httpEntity, String.class, new Object[0]).getBody();
            }
            if (ParamUtil.isNotEmpty(params)) {
                return (String)HttpClient.getRestTemplate(requestUrl).postForEntity(requestUrl, HttpClient.mapToMultiValueMap(params), String.class, new Object[0]).getBody();
            }
            return (String)HttpClient.getRestTemplate(requestUrl).postForEntity(requestUrl, (Object)HttpMethod.POST, String.class, new Object[0]).getBody();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HttpException(e.getCause().getMessage());
        }
    }

    public static String get(String requestUrl, Map<String, String> params, Map<String, String> headers, String proxyIp, String proxyPort) {
        if (requestUrl == null) {
            throw new NullPointerException("The parameter 'requestUrl' has been used @NotNull, so it cannot be null.");
        }
        if (!ParamUtil.multiEmpty((Object[])new Object[]{proxyIp, proxyPort})) {
            HttpClient.setProxy(proxyIp, proxyPort);
        }
        try {
            if (ParamUtil.isNotEmpty(headers)) {
                HttpHeaders httpHeaders = new HttpHeaders();
                for (String s : headers.keySet()) {
                    httpHeaders.add(s, headers.get(s));
                }
                HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)httpHeaders);
                if (ParamUtil.isNotEmpty(params)) {
                    return (String)HttpClient.getRestTemplate(requestUrl).exchange(UrlUtil.urlAppend(requestUrl, params), HttpMethod.GET, httpEntity, String.class, params).getBody();
                }
                return (String)HttpClient.getRestTemplate(requestUrl).exchange(requestUrl, HttpMethod.GET, httpEntity, String.class, new Object[0]).getBody();
            }
            if (ParamUtil.isNotEmpty(params)) {
                return (String)HttpClient.getRestTemplate(requestUrl).getForObject(UrlUtil.urlAppend(requestUrl, params), String.class, params);
            }
            return (String)HttpClient.getRestTemplate(requestUrl).getForObject(requestUrl, String.class, new Object[0]);
        }
        catch (Exception e) {
            throw new HttpException(e.getMessage());
        }
    }

    private static void setProxy(String proxyHost, String proxyPort) {
        System.setProperty("http.proxyHost", proxyHost);
        System.setProperty("http.proxyPort", proxyPort);
        System.setProperty("https.proxyHost", proxyHost);
        System.setProperty("https.proxyPort", proxyPort);
    }

    private static RestTemplate getRestTemplate(String url) {
        String[] urlArr = ParamUtil.split((String)url, (String)":");
        if (ParamUtil.isNotEmpty((Object)urlArr)) {
            if (Objects.equals(ParamUtil.toLowerCase((String)urlArr[0]), HttpType.HTTP.getType())) {
                return REST_TEMPLATE;
            }
            if (Objects.equals(ParamUtil.toLowerCase((String)urlArr[0]), HttpType.HTTPS.getType())) {
                return REST_TEMPLATE2;
            }
            throw new HttpException("The requested url is invalid, please use an http or https address");
        }
        throw new HttpException("The parameter requestUrl cannot be null");
    }

    private static MultiValueMap<String, String> mapToMultiValueMap(Map<String, String> map) {
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
        for (String s : map.keySet()) {
            multiValueMap.add((Object)s, (Object)map.get(s));
        }
        return multiValueMap;
    }
}

