/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.excel.valid.handler;

import cn.gjing.excel.base.context.ExcelWriterContext;
import cn.gjing.excel.base.util.ParamUtils;
import cn.gjing.excel.valid.ExcelRepeatValid;
import cn.gjing.excel.valid.ValidUtil;
import cn.gjing.excel.valid.handler.ValidAnnotationHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellRangeAddressList;

public class RepeatAnnotationHandler
extends ValidAnnotationHandler {
    public RepeatAnnotationHandler() {
        super(ExcelRepeatValid.class);
    }

    @Override
    public void handle(Annotation validAnnotation, ExcelWriterContext writerContext, Field field, Row row, int colIndex, Map<String, String[]> boxValues, Map<String, String[]> cascadeValues) {
        int startCol;
        int startRow;
        int lastRow;
        int firstRow = row.getRowNum() + 1;
        ExcelRepeatValid repeatValid = (ExcelRepeatValid)validAnnotation;
        int n = lastRow = repeatValid.rows() == 0 ? firstRow : repeatValid.rows() + firstRow - 1;
        if (writerContext.getSheet() instanceof HSSFSheet) {
            startRow = firstRow == 1 ? 1 : firstRow - writerContext.getSheet().getLastRowNum();
            startCol = 0;
        } else {
            startRow = firstRow + 1;
            startCol = colIndex;
        }
        String index = ParamUtils.numberToEn((int)startCol);
        String formula = repeatValid.longNumber() ? "COUNTIF(" + index + ":" + index + "," + index + startRow + "&\"*\")<2" : "COUNTIF(" + index + ":" + index + "," + index + startRow + ")<2";
        DataValidationHelper helper = writerContext.getSheet().getDataValidationHelper();
        DataValidationConstraint customConstraint = helper.createCustomConstraint(formula);
        CellRangeAddressList regions = new CellRangeAddressList(firstRow, lastRow, colIndex, colIndex);
        DataValidation validation = helper.createValidation(customConstraint, regions);
        ValidUtil.setErrorBox(validation, repeatValid.error(), repeatValid.rank(), repeatValid.errTitle(), repeatValid.errMsg(), repeatValid.prompt(), repeatValid.pTitle(), repeatValid.pMsg());
        writerContext.getSheet().addValidationData(validation);
    }
}

